/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.testing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlazedListsTests {
    private static final Comparator<String> FIRST_LETTER_COMPARATOR = new FirstLetterComparator();
    private static final Comparator<String> LAST_LETTER_COMPARATOR = new LastLetterComparator();

    private GlazedListsTests() {
        throw new UnsupportedOperationException();
    }

    public static List<String> delimitedStringToList(String delimited) {
        String[] strings = delimited.split("\\s");
        ArrayList<String> result = new ArrayList<String>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            result.add(strings[i]);
        }
        return result;
    }

    public static List<String> stringToList(CharSequence chars) {
        ArrayList<String> result = new ArrayList<String>(chars.length());
        for (int i = 0; i < chars.length(); ++i) {
            result.add(((Object)chars.subSequence(i, i + 1)).toString());
        }
        return result;
    }

    public static List<List<String>> stringToLists(CharSequence chars) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        String[] strings = ((Object)chars).toString().split(",");
        for (int i = 0; i < strings.length; ++i) {
            result.add(GlazedListsTests.stringToList(strings[i]));
        }
        return result;
    }

    public static List<String> stringsToList(CharSequence[] data) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < data.length; ++i) {
            result.addAll(GlazedListsTests.stringToList(data[i]));
        }
        return result;
    }

    public static List<Integer> intArrayToIntegerCollection(int[] values) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            result.add(new Integer(values[i]));
        }
        return result;
    }

    public static Matcher<Number> matchAtLeast(int minimum) {
        return new AtLeastMatcher(minimum);
    }

    public static <T> T serialize(T object) throws IOException, ClassNotFoundException {
        return (T)GlazedListsTests.fromBytes(GlazedListsTests.toBytes(object));
    }

    public static byte[] toBytes(Object object) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objectsOut = new ObjectOutputStream(bytesOut);
        objectsOut.writeObject(object);
        return bytesOut.toByteArray();
    }

    public static Object fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream objectsIn = new ObjectInputStream(bytesIn);
        return objectsIn.readObject();
    }

    public static String toString(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (int b = 0; b < bytes.length; ++b) {
            result.append(bytes[b] < 0 ? "-" : " ");
            String hexString = Integer.toString(Math.abs(bytes[b]), 16);
            while (hexString.length() < 2) {
                hexString = "0" + hexString;
            }
            result.append("0x").append(hexString).append(", ");
            if (b % 16 != 15) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public static Comparator<String> getFirstLetterComparator() {
        return FIRST_LETTER_COMPARATOR;
    }

    public static Comparator<String> getLastLetterComparator() {
        return LAST_LETTER_COMPARATOR;
    }

    public static Comparator<int[]> intArrayComparator(int index) {
        return new IntArrayComparator(index);
    }

    public static Date createDate(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, date);
        return cal.getTime();
    }

    public static <E> Runnable createJerkyAddRunnable(EventList<E> list, E value, long duration, long pause) {
        return new JerkyAddRunnable(list, value, duration, pause);
    }

    public static class UnserializableListener
    implements ListEventListener {
        private static EventList lastSource = null;

        public void listChanged(ListEvent listChanges) {
            lastSource = listChanges.getSourceList();
        }

        public static EventList getLastSource() {
            return lastSource;
        }
    }

    public static class SerializableListener
    implements ListEventListener,
    Serializable {
        private static EventList lastSource = null;

        public void listChanged(ListEvent listChanges) {
            lastSource = listChanges.getSourceList();
        }

        public static EventList getLastSource() {
            return lastSource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListEventCounter<E>
    implements ListEventListener<E> {
        private int count = 0;

        @Override
        public void listChanged(ListEvent<E> listChanges) {
            ++this.count;
        }

        public int getCountAndReset() {
            int result = this.count;
            this.count = 0;
            return result;
        }
    }

    private static final class JerkyAddRunnable
    implements Runnable {
        private final EventList list;
        private final Object value;
        private final long duration;
        private final long pause;

        public JerkyAddRunnable(EventList list, Object value, long duration, long pause) {
            if (duration < 1L) {
                throw new IllegalArgumentException("duration must be non-negative");
            }
            if (pause < 1L) {
                throw new IllegalArgumentException("pause must be non-negative");
            }
            this.list = list;
            this.value = value;
            this.duration = duration;
            this.pause = pause;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long endTime = System.currentTimeMillis() + this.duration;
            while (System.currentTimeMillis() < endTime) {
                this.list.getReadWriteLock().writeLock().lock();
                try {
                    this.list.add(this.value);
                }
                finally {
                    this.list.getReadWriteLock().writeLock().unlock();
                }
                try {
                    Thread.sleep(this.pause);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntArrayComparator
    implements Comparator<int[]> {
        public int index;

        public IntArrayComparator(int index) {
            this.index = index;
        }

        @Override
        public int compare(int[] a, int[] b) {
            return a[this.index] - b[this.index];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LastLetterComparator
    implements Comparator<String> {
        private LastLetterComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.charAt(o1.length() - 1) - o2.charAt(o2.length() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FirstLetterComparator
    implements Comparator<String> {
        private FirstLetterComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.charAt(0) - o2.charAt(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtLeastMatcher
    implements Matcher<Number> {
        private final int minimum;

        public AtLeastMatcher(int minimum) {
            this.minimum = minimum;
        }

        @Override
        public boolean matches(Number value) {
            return value.intValue() >= this.minimum;
        }
    }
}

