/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.BandwidthCollectorDriver;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.InsufficientDataException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.core.settings.UploadSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.statistic.BasicKilobytesStatistic;
import org.limewire.statistic.Statistic;
import org.limewire.statistic.StatisticAccumulator;

@EagerSingleton
public class BandwidthCollectorImpl
implements BandwidthCollectorDriver {
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<BandwidthTracker> uploadTracker;
    private final Provider<BandwidthTracker> downloadTracker;
    private final Provider<TorrentManager> torrentManager;
    @InspectionPoint(value="upstream bandwidth history")
    private final Statistic uploadStat;
    @InspectionPoint(value="downstream bandwidth history")
    private final Statistic downloadStat;
    @InspectionPoint(value="upload bandwidth histogram")
    private final InspectionHistogram<Integer> uploadHistogram;
    @InspectionPoint(value="download bandwidth histogram")
    private final InspectionHistogram<Integer> downloadHistogram;
    private final AtomicInteger currentTotalUploadBandwidthKiloBytes = new AtomicInteger(0);
    private final AtomicInteger currentTotalDownloadBandwidthKiloBytes = new AtomicInteger(0);
    private final AtomicInteger currentUploaderPayloadBandwidthKiloBytes = new AtomicInteger(0);
    private final AtomicInteger currentDownloaderPayloadBandwidthKiloBytes = new AtomicInteger(0);

    @Inject
    public BandwidthCollectorImpl(@Named(value="uploadTracker") Provider<BandwidthTracker> uploadTracker, @Named(value="downloadTracker") Provider<BandwidthTracker> downloadTracker, Provider<ConnectionManager> connectionManager, StatisticAccumulator statisticAccumulator, Provider<TorrentManager> torrentManager) {
        this.uploadTracker = uploadTracker;
        this.downloadTracker = downloadTracker;
        this.connectionManager = connectionManager;
        this.torrentManager = torrentManager;
        this.uploadStat = new BandwidthStat(statisticAccumulator);
        this.downloadStat = new BandwidthStat(statisticAccumulator);
        this.downloadHistogram = new InspectionHistogram();
        this.uploadHistogram = new InspectionHistogram();
    }

    @Override
    public int getMaxMeasuredTotalDownloadBandwidth() {
        return DownloadSettings.MAX_MEASURED_DOWNLOAD_KBPS.getValue();
    }

    @Override
    public int getMaxMeasuredTotalUploadBandwidth() {
        return UploadSettings.MAX_MEASURED_UPLOAD_KBPS.getValue();
    }

    @Override
    public int getCurrentTotalDownloadBandwidth() {
        return this.currentTotalDownloadBandwidthKiloBytes.get();
    }

    @Override
    public int getCurrentTotalUploadBandwidth() {
        return this.currentTotalUploadBandwidthKiloBytes.get();
    }

    @Override
    public int getCurrentDownloaderBandwidth() {
        return this.currentDownloaderPayloadBandwidthKiloBytes.get();
    }

    @Override
    public int getCurrentUploaderBandwidth() {
        return this.currentUploaderPayloadBandwidthKiloBytes.get();
    }

    @Override
    public void collectBandwidthData() {
        int maxDownstreamKiloBytesPerSec;
        this.uploadTracker.get().measureBandwidth();
        this.downloadTracker.get().measureBandwidth();
        this.connectionManager.get().measureBandwidth();
        float uploadTrackerBandwidth = this.getUploadTrackerBandwidth();
        float downloadTrackerBandwidth = this.getDownloadTrackerBandwidth();
        float connectionManagerUploadBandwidth = this.connectionManager.get().getMeasuredUpstreamBandwidth();
        float connectionManagerDownloadBandwidth = this.connectionManager.get().getMeasuredDownstreamBandwidth();
        List<Torrent> torrents = this.torrentManager.get().getTorrents();
        float torrentUploadBandwidth = this.calculateTorrentUpstreamBandwidth(torrents);
        float torrentUploadPayloadBandwidth = this.calculateTorrentUpstreamPayloadBandwidth(torrents);
        int newUpstreamKiloBytesPerSec = (int)this.addPositive(this.addPositive(uploadTrackerBandwidth, connectionManagerUploadBandwidth), torrentUploadBandwidth);
        int newUploaderKiloBytesPerSec = (int)this.addPositive(uploadTrackerBandwidth, torrentUploadPayloadBandwidth);
        this.uploadStat.addData(newUpstreamKiloBytesPerSec);
        this.uploadHistogram.count(newUpstreamKiloBytesPerSec);
        int newDownstreamKiloBytesPerSec = (int)this.addPositive(downloadTrackerBandwidth, connectionManagerDownloadBandwidth);
        int newDownloaderKiloBytesPerSec = (int)this.addPositive(0.0f, downloadTrackerBandwidth);
        this.downloadStat.addData(newDownstreamKiloBytesPerSec);
        this.downloadHistogram.count(newDownstreamKiloBytesPerSec);
        int maxUpstreamKiloBytesPerSec = this.getMaxMeasuredTotalUploadBandwidth();
        if (newUpstreamKiloBytesPerSec > maxUpstreamKiloBytesPerSec) {
            maxUpstreamKiloBytesPerSec = newUpstreamKiloBytesPerSec;
            UploadSettings.MAX_MEASURED_UPLOAD_KBPS.setValue(maxUpstreamKiloBytesPerSec);
        }
        if (newDownstreamKiloBytesPerSec > (maxDownstreamKiloBytesPerSec = this.getMaxMeasuredTotalDownloadBandwidth())) {
            maxDownstreamKiloBytesPerSec = newDownstreamKiloBytesPerSec;
            DownloadSettings.MAX_MEASURED_DOWNLOAD_KBPS.setValue(maxDownstreamKiloBytesPerSec);
        }
        this.currentDownloaderPayloadBandwidthKiloBytes.set(newDownloaderKiloBytesPerSec);
        this.currentUploaderPayloadBandwidthKiloBytes.set(newUploaderKiloBytesPerSec);
        this.currentTotalDownloadBandwidthKiloBytes.set(newDownstreamKiloBytesPerSec);
        this.currentTotalUploadBandwidthKiloBytes.set(newUpstreamKiloBytesPerSec);
    }

    private float getDownloadTrackerBandwidth() {
        float bandwidth;
        try {
            bandwidth = this.downloadTracker.get().getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            bandwidth = 0.0f;
        }
        return bandwidth;
    }

    private float getUploadTrackerBandwidth() {
        float bandwidth;
        try {
            bandwidth = this.uploadTracker.get().getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            bandwidth = 0.0f;
        }
        return bandwidth;
    }

    private float calculateTorrentUpstreamBandwidth(List<Torrent> torrents) {
        float rate = 0.0f;
        for (Torrent torrent : this.torrentManager.get().getTorrents()) {
            TorrentStatus torrentStatus = torrent.getStatus();
            if (torrentStatus == null) continue;
            rate = this.addPositive(rate, torrentStatus.getUploadRate());
        }
        return rate / 1024.0f;
    }

    private float calculateTorrentUpstreamPayloadBandwidth(List<Torrent> torrents) {
        float rate = 0.0f;
        for (Torrent torrent : this.torrentManager.get().getTorrents()) {
            TorrentStatus torrentStatus = torrent.getStatus();
            if (torrentStatus == null || torrentStatus.isPaused()) continue;
            rate = this.addPositive(rate, torrentStatus.getUploadPayloadRate());
        }
        return rate / 1024.0f;
    }

    private float addPositive(float one, float two) {
        float sum = 0.0f;
        if (one > 0.0f) {
            sum += one;
        }
        if (two > 0.0f) {
            sum += two;
        }
        return sum;
    }

    private class BandwidthStat
    extends BasicKilobytesStatistic {
        public BandwidthStat(StatisticAccumulator statisticAccumulator) {
            super(statisticAccumulator);
        }
    }
}

