/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.limegroup.gnutella.ActiveLimeWireCheck;
import com.limegroup.gnutella.LifecycleManager;
import com.limegroup.gnutella.LimeCoreGlue;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.core.api.lifecycle.LifeCycleEvent;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.service.ErrorService;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;
import org.limewire.util.VersionUtils;

@EagerSingleton
public class LifecycleManagerImpl
implements LifecycleManager {
    private static final Log LOG = LogFactory.getLog(LifecycleManagerImpl.class);
    private final AtomicBoolean preinitializeBegin = new AtomicBoolean(false);
    private final AtomicBoolean preinitializeDone = new AtomicBoolean(false);
    private final AtomicBoolean backgroundBegin = new AtomicBoolean(false);
    private final AtomicBoolean backgroundDone = new AtomicBoolean(false);
    private final AtomicBoolean startBegin = new AtomicBoolean(false);
    private final AtomicBoolean startDone = new AtomicBoolean(false);
    private final AtomicBoolean shutdownBegin = new AtomicBoolean(false);
    private final AtomicBoolean shutdownDone = new AtomicBoolean(false);
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final EventListenerList<LifeCycleEvent> listenerList;
    @InspectablePrimitive(value="time lifecycle finished starting")
    private long startFinishedTime;
    private final ServiceRegistry serviceRegistry;
    @InspectionPoint(value="ungraceful shutdown details")
    private final Inspectable ungracefulShutdownDetails = new Inspectable(){

        @Override
        public Object inspect() {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("JVM version", VersionUtils.getJavaVersion());
            data.put("OS", OSUtils.getOS());
            data.put("OS version", OSUtils.getOSVersion());
            data.put("graceful shutdown", ApplicationSettings.PREVIOUS_SHUTDOWN_WAS_GRACEFUL.getValue());
            return data;
        }
    };

    @Inject
    public LifecycleManagerImpl(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.listenerList = new EventListenerList();
    }

    @Override
    public boolean isLoaded() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STARTING;
    }

    @Override
    public boolean isStarted() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STOPPED;
    }

    @Override
    public boolean isShutdown() {
        return this.getCurrentState() == State.STOPPED;
    }

    private void installListeners() {
        if (this.preinitializeBegin.getAndSet(true)) {
            return;
        }
        LimeCoreGlue.preinstall();
        this.serviceRegistry.initialize();
        this.preinitializeDone.set(true);
    }

    @Override
    public void loadBackgroundTasks() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        ThreadExecutor.startThread(new Runnable(){

            @Override
            public void run() {
                LifecycleManagerImpl.this.doBackgroundTasks();
            }
        }, "BackgroundTasks");
    }

    private void loadBackgroundTasksBlocking() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        this.doBackgroundTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.startBegin.getAndSet(true)) {
            return;
        }
        try {
            this.listenerList.broadcast(LifeCycleEvent.STARTING);
            this.doStart();
            this.listenerList.broadcast(LifeCycleEvent.STARTED);
        }
        finally {
            this.startLatch.countDown();
        }
    }

    void doStart() {
        if (ApplicationSettings.CURRENTLY_RUNNING.getValue()) {
            ApplicationSettings.PREVIOUS_SHUTDOWN_WAS_GRACEFUL.setValue(false);
        } else {
            ApplicationSettings.PREVIOUS_SHUTDOWN_WAS_GRACEFUL.setValue(true);
        }
        ApplicationSettings.CURRENTLY_RUNNING.setValue(true);
        SettingsGroupManager.instance().save();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ActiveLimeWireCheck.instance().releaseLock();
            }
        });
        this.loadBackgroundTasksBlocking();
        this.serviceRegistry.start();
        if (ApplicationSettings.AUTOMATIC_MANUAL_GC.getValue()) {
            this.startManualGCThread();
        }
        this.startDone.set(true);
        this.startFinishedTime = System.currentTimeMillis();
    }

    @Override
    public void shutdown() {
        try {
            this.listenerList.broadcast(LifeCycleEvent.SHUTINGDOWN);
            this.doShutdown();
            this.listenerList.broadcast(LifeCycleEvent.SHUTDOWN);
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    private void doShutdown() {
        if (!this.startBegin.get() || this.shutdownBegin.getAndSet(true)) {
            return;
        }
        try {
            this.startLatch.await();
        }
        catch (InterruptedException ie) {
            LOG.error("Interrupted while waiting to finish starting", ie);
            return;
        }
        this.serviceRegistry.stop();
        ApplicationSettings.CURRENTLY_RUNNING.setValue(false);
        SettingsGroupManager.instance().save();
        this.shutdownDone.set(true);
    }

    private static String parseCommand(String toCall) {
        if (toCall.startsWith("\"")) {
            int end = toCall.indexOf("\"", 1);
            if (end > -1) {
                return toCall.substring(0, end + 1);
            }
            return toCall + "\"";
        }
        int space = toCall.indexOf(" ");
        if (space > -1) {
            return toCall.substring(0, space);
        }
        return toCall;
    }

    @Override
    public void shutdown(String toExecute) {
        this.shutdown();
        if (toExecute != null) {
            try {
                if (OSUtils.isWindowsVista()) {
                    String cmd = LifecycleManagerImpl.parseCommand(toExecute).trim();
                    String params = toExecute.substring(cmd.length()).trim();
                    SystemUtils.openFile(cmd, params);
                } else {
                    Runtime.getRuntime().exec(toExecute);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public long getStartFinishedTime() {
        return this.startFinishedTime;
    }

    private void doBackgroundTasks() {
        this.serviceRegistry.start("SuperEarly");
        this.serviceRegistry.start("EarlyBackground");
        this.backgroundDone.set(true);
    }

    private State getCurrentState() {
        if (this.shutdownBegin.get()) {
            return State.STOPPED;
        }
        if (this.startDone.get()) {
            return State.STARTED;
        }
        if (this.startBegin.get()) {
            return State.STARTING;
        }
        return State.NONE;
    }

    private void startManualGCThread() {
        Thread t = ThreadExecutor.newManagedThread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOG.trace("Running GC");
                    System.gc();
                    LOG.trace("GC finished, running finalizers");
                    System.runFinalization();
                    LOG.trace("Finalizers finished.");
                }
            }
        }, "ManualGC");
        t.setDaemon(true);
        t.start();
        LOG.trace("Started manual GC thread.");
    }

    @Override
    public void addListener(EventListener<LifeCycleEvent> listener) {
        this.listenerList.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<LifeCycleEvent> listener) {
        return this.listenerList.removeListener(listener);
    }

    private static enum State {
        NONE,
        STARTING,
        STARTED,
        STOPPED;

    }
}

