/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.LimeProps;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.mojito.settings.MojitoProps;
import org.limewire.util.CommonUtils;

@EagerSingleton
public class LimeCoreGlue
implements Service {
    private static AtomicBoolean preinstalled = new AtomicBoolean(false);
    private AtomicBoolean installed = new AtomicBoolean(false);
    private final Provider<SimppManager> simppManager;

    @Inject
    public LimeCoreGlue(Provider<SimppManager> simppManager) {
        this.simppManager = simppManager;
    }

    public static void preinstall() throws InstallFailedException {
        LimeCoreGlue.preinstall(null);
    }

    public static void preinstall(File userSettingsDir) throws InstallFailedException {
        if (!preinstalled.compareAndSet(false, true)) {
            return;
        }
        if (userSettingsDir == null) {
            userSettingsDir = LimeWireUtils.getRequestedUserSettingsLocation();
        }
        try {
            CommonUtils.setUserSettingsDir(userSettingsDir);
        }
        catch (IOException requestedFailed) {
            try {
                File temporaryDir;
                LimeWireUtils.clearTemporarySettingsDirectories();
                try {
                    temporaryDir = LimeWireUtils.getTemporarySettingsDirectory();
                }
                catch (IOException tempFailed) {
                    tempFailed.initCause(requestedFailed);
                    throw tempFailed;
                }
                temporaryDir.deleteOnExit();
                try {
                    CommonUtils.setUserSettingsDir(temporaryDir);
                }
                catch (IOException cannotSet) {
                    cannotSet.initCause(requestedFailed);
                    throw cannotSet;
                }
                LimeWireUtils.setTemporaryDirectoryInUse(true);
            }
            catch (IOException totalFailure) {
                throw new InstallFailedException("Settings Directory Failure", totalFailure);
            }
        }
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this).in("SuperEarly");
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Core Glue");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        this.install();
    }

    @Override
    public void stop() {
    }

    public void install() {
        if (!this.installed.compareAndSet(false, true)) {
            return;
        }
        LimeCoreGlue.preinstall();
        SimppSettingsManager core = new SimppSettingsManager();
        SimppSettingsManager mojito = new SimppSettingsManager();
        this.simppManager.get().addSimppSettingsManager(core);
        this.simppManager.get().addSimppSettingsManager(mojito);
        LimeProps.instance().getFactory().setRemoteSettingManager(core);
        MojitoProps.instance().getFactory().setRemoteSettingManager(mojito);
        if (ApplicationSettings.INITIALIZE_SIMPP.getValue()) {
            this.simppManager.get().initialize();
        }
    }

    public static class InstallFailedException
    extends RuntimeException {
        public InstallFailedException() {
        }

        public InstallFailedException(String message, Throwable cause) {
            super(message, cause);
        }

        public InstallFailedException(String message) {
            super(message);
        }

        public InstallFailedException(Throwable cause) {
            super(cause);
        }
    }
}

