/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.limewire.collection.ForgetfulHashMap;
import org.limewire.collection.MultiIterable;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.settings.FilterSettings;
import org.limewire.io.GUID;
import org.limewire.util.StringUtils;

@Singleton
public class ResponseVerifierImpl
implements ResponseVerifier {
    private ForgetfulHashMap<GUID, RequestData> mapper = new ForgetfulHashMap(15);
    private static final String DELIMITERS = "+ ";
    private static final long Mandragore_SIZE = 8192L;
    private final CategoryManager categoryManager;

    @Inject
    public ResponseVerifierImpl(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    @Override
    public synchronized void record(QueryRequest qr) {
        this.record(qr, null);
    }

    @Override
    public synchronized void record(QueryRequest qr, SearchCategory type) {
        byte[] guid = qr.getGUID();
        this.mapper.put(new GUID(guid), new RequestData(qr.getQuery(), qr.getRichQuery(), type, qr.isWhatIsNewRequest()));
    }

    @Override
    public synchronized boolean matchesQuery(byte[] guid, Response response) {
        RequestData data = (RequestData)this.mapper.get(new GUID(guid));
        if (data == null || data.queryWords == null) {
            return false;
        }
        if (data.whatIsNew) {
            return true;
        }
        int minGood = FilterSettings.MIN_MATCHING_WORDS.getValue();
        if (ResponseVerifierImpl.score(data.queryWords, response.getName()) > minGood) {
            return true;
        }
        LimeXMLDocument doc = response.getDocument();
        if (doc != null) {
            for (String xmlWord : new MultiIterable<String>((Iterable<String>)doc.getKeyWords(), (Iterable<String>)doc.getKeyWordsIndivisible())) {
                if (ResponseVerifierImpl.score(data.queryWords, xmlWord) <= minGood) continue;
                return true;
            }
        }
        return false;
    }

    public static int score(String query, LimeXMLDocument richQuery, RemoteFileDesc response) {
        return ResponseVerifierImpl.score(ResponseVerifierImpl.getSearchTerms(query, richQuery), response.getFileName());
    }

    public static int score(List<String> queryWords, String filename) {
        int numMatchingWords = 0;
        int numQueryWords = queryWords.size();
        if (numQueryWords == 0) {
            return 100;
        }
        for (int i = 0; i < numQueryWords; ++i) {
            String pattern = queryWords.get(i);
            if (!StringUtils.contains(filename, pattern, true)) continue;
            ++numMatchingWords;
        }
        return (int)(100.0f * ((float)numMatchingWords / (float)numQueryWords));
    }

    @Override
    public boolean matchesType(byte[] guid, Response response) {
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null || request.type == null) {
            return true;
        }
        String reply = response.getName();
        Category category = request.type.getCategory();
        if (category != null) {
            return this.categoryManager.getCategoryForFilename(reply) == category;
        }
        return true;
    }

    @Override
    public boolean isMandragoreWorm(byte[] guid, Response response) {
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null) {
            return false;
        }
        return response.getSize() == 8192L && response.getName().equals(request.query + ".exe");
    }

    @Override
    public synchronized String getQueryString(byte[] guid) {
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null) {
            return null;
        }
        return request.query;
    }

    public String toString() {
        return this.mapper.toString();
    }

    private static List<String> getSearchTerms(String query, LimeXMLDocument richQuery) {
        String[] terms = null;
        HashSet<String> qWords = new HashSet<String>();
        terms = StringUtils.split(query.toLowerCase(), DELIMITERS);
        for (int i = 0; i < terms.length; ++i) {
            qWords.add(terms[i]);
        }
        List<String> xmlWords = null;
        if (richQuery != null) {
            xmlWords = richQuery.getKeyWords();
            int size = xmlWords.size();
            for (int i = 0; i < size; ++i) {
                String currWord = xmlWords.remove(0);
                qWords.add(currWord.toLowerCase());
            }
        }
        return Collections.unmodifiableList(new ArrayList(qWords));
    }

    private static class RequestData {
        final String query;
        final List<String> queryWords;
        final SearchCategory type;
        final boolean whatIsNew;

        RequestData(String query, LimeXMLDocument richQuery, SearchCategory type, boolean whatIsNew) {
            this.query = query;
            this.queryWords = ResponseVerifierImpl.getSearchTerms(query, richQuery);
            this.type = type;
            this.whatIsNew = whatIsNew;
        }
    }
}

