/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.filters.URNFilter;
import com.limegroup.gnutella.filters.response.ResponseFilterFactory;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.search.SearchResultHandler;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.FilterSettings;

@Singleton
public class SpamServicesImpl
implements SpamServices,
SpamFilter.LoadCallback {
    private static final Log LOG = LogFactory.getLog(SpamServicesImpl.class);
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<IPFilter> ipFilter;
    private final Provider<URNFilter> urnFilter;
    private final SpamFilterFactory spamFilterFactory;
    private final Provider<SearchResultHandler> searchResultHandler;
    private final ResponseFilterFactory responseFilterFactory;
    private volatile SpamFilter personalFilter;
    private final AtomicInteger filtersLoading;

    @Inject
    public SpamServicesImpl(Provider<ConnectionManager> connectionManager, Provider<IPFilter> ipFilter, Provider<URNFilter> urnFilter, SpamFilterFactory spamFilterFactory, Provider<SearchResultHandler> searchResultHandler, ResponseFilterFactory responseFilterFactory) {
        this.connectionManager = connectionManager;
        this.ipFilter = ipFilter;
        this.urnFilter = urnFilter;
        this.spamFilterFactory = spamFilterFactory;
        this.searchResultHandler = searchResultHandler;
        this.responseFilterFactory = responseFilterFactory;
        this.filtersLoading = new AtomicInteger(0);
    }

    @Override
    public void spamFilterLoaded() {
        if (this.filtersLoading.decrementAndGet() == 0) {
            this.adjustSpamFilters();
        }
    }

    @Override
    public void adjustSpamFilters() {
        LOG.trace("Adjusting spam filters");
        this.personalFilter = this.spamFilterFactory.createPersonalFilter();
        this.searchResultHandler.get().setResponseFilter(this.responseFilterFactory.createResponseFilter());
        for (RoutedConnection c : this.connectionManager.get().getConnections()) {
            if (this.ipFilter.get().allow(c.getAddress())) {
                c.setRouteFilter(this.spamFilterFactory.createRouteFilter());
                continue;
            }
            c.close();
        }
    }

    @Override
    public void reloadIPFilter() {
        LOG.trace("Reloading IP filter");
        this.filtersLoading.addAndGet(1);
        this.ipFilter.get().refreshHosts(this);
    }

    @Override
    public void reloadSpamFilters() {
        LOG.trace("Reloading spam filters");
        this.filtersLoading.addAndGet(2);
        this.ipFilter.get().refreshHosts(this);
        this.urnFilter.get().refreshURNs(this);
    }

    @Override
    public boolean isAllowed(InetAddress host) {
        return this.ipFilter.get().allow(host.getAddress());
    }

    @Override
    public void blockHost(String host) {
        String[] bannedIPs = FilterSettings.BLACK_LISTED_IP_ADDRESSES.get();
        ArrayList<String> bannedList = new ArrayList<String>(Arrays.asList(bannedIPs));
        if (!bannedList.contains(host)) {
            bannedList.add(host);
            bannedIPs = bannedList.toArray(bannedIPs);
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.set(bannedIPs);
            this.reloadIPFilter();
        }
    }

    @Override
    public void unblockHost(String host) {
        String[] bannedIPs = FilterSettings.BLACK_LISTED_IP_ADDRESSES.get();
        List<String> bannedList = Arrays.asList(bannedIPs);
        if (bannedList.remove(host)) {
            bannedIPs = bannedList.toArray(bannedIPs);
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.set(bannedIPs);
            this.reloadIPFilter();
        }
    }

    @Override
    public boolean isPersonalSpam(Message m) {
        if (this.personalFilter == null) {
            this.personalFilter = this.spamFilterFactory.createPersonalFilter();
        }
        return !this.personalFilter.allow(m);
    }
}

