/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.auth.IpPortContentAuthority;
import com.limegroup.gnutella.auth.IpPortContentAuthorityFactory;
import org.limewire.io.IpPort;

@Singleton
public class IpPortContentAuthorityFactoryImpl
implements IpPortContentAuthorityFactory {
    private final Provider<UDPService> udpService;

    @Inject
    public IpPortContentAuthorityFactoryImpl(Provider<UDPService> udpService) {
        this.udpService = udpService;
    }

    @Override
    public IpPortContentAuthority createIpPortContentAuthority(IpPort host) {
        return new IpPortContentAuthority(host, this.udpService.get());
    }

    @Override
    public IpPortContentAuthority createIpPortContentAuthority(String host, int port) {
        return new IpPortContentAuthority(host, port, this.udpService.get());
    }
}

