/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.bootstrap.Bootstrapper;
import com.limegroup.gnutella.bootstrap.TcpBootstrap;
import com.limegroup.gnutella.bootstrap.UDPHostCache;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.inspection.InspectablePrimitive;

@Singleton
class BootstrapperImpl
implements Bootstrapper {
    private static final Log LOG = LogFactory.getLog(BootstrapperImpl.class);
    static int MULTICAST_INTERVAL = 50000;
    static int UDP_FALLBACK_DELAY = 2000;
    static int UDP_INTERVAL = 30000;
    static int TCP_FALLBACK_DELAY = 40000;
    static int TCP_INTERVAL = 300000;
    private long firstBootstrapCheck = 0L;
    private long nextAllowedMulticastTime = 0L;
    private long nextAllowedUdpTime = Long.MAX_VALUE;
    private long nextAllowedTcpTime = Long.MAX_VALUE;
    @InspectablePrimitive(value="multicast bootstrapping")
    private boolean triedMulticast = false;
    @InspectablePrimitive(value="udp bootstrapping")
    private boolean triedUDP = false;
    @InspectablePrimitive(value="tcp bootstrapping")
    private boolean triedTCP = false;
    private final ConnectionServices connectionServices;
    private final Provider<MulticastService> multicastService;
    private final PingRequestFactory pingRequestFactory;
    private final Bootstrapper.Listener listener;
    private final TcpBootstrap tcpBootstrap;
    private final UDPHostCache udpHostCache;

    @Inject
    public BootstrapperImpl(ConnectionServices connectionServices, Provider<MulticastService> multicastService, PingRequestFactory pingRequestFactory, Bootstrapper.Listener listener, TcpBootstrap tcpBootstrap, UDPHostCache udpHostCache) {
        this.connectionServices = connectionServices;
        this.multicastService = multicastService;
        this.pingRequestFactory = pingRequestFactory;
        this.listener = listener;
        this.tcpBootstrap = tcpBootstrap;
        this.udpHostCache = udpHostCache;
    }

    @Override
    public synchronized void run() {
        if (ConnectionSettings.DO_NOT_BOOTSTRAP.getValue()) {
            LOG.trace("Not bootstrapping");
            return;
        }
        long now = System.currentTimeMillis();
        if (this.firstBootstrapCheck == 0L) {
            this.firstBootstrapCheck = now;
        }
        if (this.needsHosts(now)) {
            this.multicastFetch(now);
            this.udpHostCacheFetch(now);
            this.tcpHostCacheFetch(now);
        }
    }

    @Override
    public void reset() {
        this.firstBootstrapCheck = 0L;
        this.nextAllowedMulticastTime = 0L;
        this.nextAllowedUdpTime = Long.MAX_VALUE;
        this.nextAllowedTcpTime = Long.MAX_VALUE;
        this.tcpBootstrap.resetData();
        this.udpHostCache.resetData();
        this.tcpBootstrap.loadDefaults();
        this.udpHostCache.loadDefaults();
    }

    @Override
    public boolean addUDPHostCache(ExtendedEndpoint ee) {
        return this.udpHostCache.add(ee);
    }

    @Override
    public boolean isWriteDirty() {
        return this.udpHostCache.isWriteDirty();
    }

    @Override
    public void write(Writer out) throws IOException {
        this.udpHostCache.write(out);
    }

    private boolean needsHosts(long now) {
        if (this.listener.needsHosts()) {
            LOG.trace("Need hosts: none known");
            return true;
        }
        long delay = now - this.firstBootstrapCheck;
        if (!this.connectionServices.isConnected() && delay > (long)ConnectionSettings.BOOTSTRAP_DELAY.getValue()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Need hosts: not connected after " + delay + " milliseconds");
            }
            return true;
        }
        LOG.trace("Do not need hosts");
        return false;
    }

    private boolean multicastFetch(long now) {
        if (ConnectionSettings.DO_NOT_MULTICAST_BOOTSTRAP.getValue()) {
            LOG.trace("Never fetching via multicast");
            if (this.nextAllowedUdpTime == Long.MAX_VALUE) {
                this.nextAllowedUdpTime = 0L;
            }
            return false;
        }
        if (this.nextAllowedMulticastTime < now) {
            LOG.trace("Fetching via multicast");
            PingRequest pr = this.pingRequestFactory.createMulticastPing();
            this.multicastService.get().send(pr);
            this.triedMulticast = true;
            this.nextAllowedMulticastTime = now + (long)MULTICAST_INTERVAL;
            if (this.nextAllowedUdpTime == Long.MAX_VALUE) {
                this.nextAllowedUdpTime = now + (long)UDP_FALLBACK_DELAY;
            }
            return true;
        }
        LOG.trace("Not fetching via multicast");
        return false;
    }

    private boolean udpHostCacheFetch(long now) {
        if (this.nextAllowedUdpTime < now) {
            LOG.trace("Fetching via UDP");
            this.udpHostCache.fetchHosts();
            this.triedUDP = true;
            this.nextAllowedUdpTime = now + (long)UDP_INTERVAL;
            if (this.nextAllowedTcpTime == Long.MAX_VALUE) {
                this.nextAllowedTcpTime = now + (long)TCP_FALLBACK_DELAY;
            }
            return true;
        }
        LOG.trace("Not fetching via UDP");
        return false;
    }

    private boolean tcpHostCacheFetch(long now) {
        if (this.nextAllowedTcpTime < now) {
            LOG.trace("Fetching via TCP");
            this.tcpBootstrap.fetchHosts(this.listener);
            this.triedTCP = true;
            this.nextAllowedTcpTime = now + (long)TCP_INTERVAL;
            return true;
        }
        LOG.trace("Not fetching via TCP");
        return false;
    }
}

