/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.AltLocValueFactory;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.limewire.collection.MultiCollection;
import org.limewire.core.settings.DHTSettings;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.db.StorableModel;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.DatabaseUtils;

@Singleton
public class AltLocModel
implements StorableModel {
    private final Map<KUID, Storable> values = Collections.synchronizedMap(new HashMap());
    private final AltLocValueFactory altLocValueFactory;
    private final Provider<HashTreeCache> tigerTreeCache;
    private final FileView gnutellaFileView;

    @Inject
    public AltLocModel(AltLocValueFactory altLocValueFactory, @GnutellaFiles FileView gnutellaFileView, Provider<HashTreeCache> tigerTreeCache) {
        this.altLocValueFactory = altLocValueFactory;
        this.gnutellaFileView = gnutellaFileView;
        this.tigerTreeCache = tigerTreeCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Storable> getStorables() {
        if (!DHTSettings.PUBLISH_ALT_LOCS.getValue()) {
            this.values.clear();
            return Collections.emptySet();
        }
        ArrayList<Storable> toRemove = new ArrayList<Storable>();
        ArrayList<Storable> toPublish = new ArrayList<Storable>();
        Map<KUID, Storable> map = this.values;
        synchronized (map) {
            this.gnutellaFileView.getReadLock().lock();
            try {
                for (FileDesc fd : this.gnutellaFileView) {
                    URN urn = fd.getSHA1Urn();
                    KUID primaryKey = KUIDUtils.toKUID(urn);
                    if (this.values.containsKey(primaryKey)) continue;
                    long fileSize = fd.getFileSize();
                    HashTree hashTree = this.tigerTreeCache.get().getHashTree(urn);
                    byte[] ttroot = null;
                    if (hashTree != null) {
                        ttroot = hashTree.getRootHashBytes();
                    }
                    AltLocValue value = this.altLocValueFactory.createAltLocValueForSelf(fileSize, ttroot);
                    this.values.put(primaryKey, new Storable(primaryKey, value));
                }
            }
            finally {
                this.gnutellaFileView.getReadLock().unlock();
            }
            Iterator<Storable> it = this.values.values().iterator();
            while (it.hasNext()) {
                Storable storable = it.next();
                KUID primaryKey = storable.getPrimaryKey();
                URN urn = KUIDUtils.toURN(primaryKey);
                FileDesc fd = this.gnutellaFileView.getFileDesc(urn);
                if (fd == null) {
                    storable = new Storable(primaryKey, DHTValue.EMPTY_VALUE);
                    it.remove();
                    toRemove.add(storable);
                    continue;
                }
                if (!fd.isRareFile() || !DatabaseUtils.isPublishingRequired(storable)) continue;
                toPublish.add(storable);
            }
        }
        Collections.shuffle(toPublish);
        return new MultiCollection<Storable>((Collection<Storable>)toRemove, (Collection<Storable>)toPublish);
    }

    @Override
    public void handleStoreResult(Storable storable, StoreResult result) {
    }

    @Override
    public void handleContactChange() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder("AltLocPublisher: ");
        Map<KUID, Storable> map = this.values;
        synchronized (map) {
            buffer.append(CollectionUtils.toString(this.values.values()));
        }
        return buffer.toString();
    }
}

