/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.dht.db.AbstractPushProxiesValue;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GGEP;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.exceptions.DHTValueException;
import org.limewire.mojito.routing.Version;
import org.limewire.util.ByteUtils;

public class PushProxiesValueImpl
extends AbstractPushProxiesValue {
    private static final long serialVersionUID = -2912251955825278890L;
    private final byte[] guid;
    private final byte features;
    private final int fwtVersion;
    private final int port;
    private final Set<? extends IpPort> proxies;
    private final byte[] data;
    private final BitNumbers tlsInfo;

    public PushProxiesValueImpl(Version version, byte[] guid, byte features, int fwtVersion, int port, Set<? extends IpPort> proxies) {
        super(version);
        this.guid = guid;
        this.features = features;
        this.fwtVersion = fwtVersion;
        this.port = port;
        this.proxies = new IpPortSet((Collection<? extends IpPort>)proxies);
        this.tlsInfo = AbstractPushProxiesValue.getNumbersFromProxies(proxies);
        this.data = AbstractPushProxiesValue.serialize(this);
    }

    public PushProxiesValueImpl(Version version, byte[] data) throws DHTValueException {
        super(version);
        if (version == null) {
            throw new DHTValueException("Version is null");
        }
        if (data == null) {
            throw new DHTValueException("Data is null");
        }
        this.data = data;
        try {
            GGEP ggep = new GGEP(data, 0);
            this.guid = ggep.getBytes("client-id");
            if (this.guid.length != 16) {
                throw new DHTValueException("Illegal GUID length: " + this.guid.length);
            }
            this.features = (byte)ggep.getInt("features");
            this.fwtVersion = ggep.getInt("fwt-version");
            byte[] portBytes = ggep.getBytes("port");
            this.port = ByteUtils.beb2short(portBytes, 0) & 0xFFFF;
            if (!NetworkUtils.isValidPort(this.port)) {
                throw new DHTValueException("Illegal port: " + this.port);
            }
            BitNumbers tlsInfo = BitNumbers.EMPTY_BN;
            try {
                tlsInfo = new BitNumbers(ggep.getBytes("tls"));
            }
            catch (BadGGEPPropertyException notThere) {
                // empty catch block
            }
            byte[] proxiesBytes = ggep.getBytes("proxies");
            ByteArrayInputStream bais = new ByteArrayInputStream(proxiesBytes);
            DataInputStream in = new DataInputStream(bais);
            IpPortSet proxies = new IpPortSet();
            int id = 0;
            while (in.available() > 0) {
                int length = in.readUnsignedByte();
                if (length != 6 && length != 18) {
                    throw new IOException("Illegal IP:Port length: " + length);
                }
                byte[] addr = new byte[length - 2];
                in.readFully(addr);
                int port = in.readUnsignedShort();
                if (!NetworkUtils.isValidPort(port)) {
                    throw new DHTValueException("Illegal port: " + port);
                }
                IpPort proxy = new IpPortImpl(InetAddress.getByAddress(addr), port);
                if (tlsInfo.isSet(id++)) {
                    proxy = new ConnectableImpl(proxy, true);
                }
                proxies.add(proxy);
            }
            this.proxies = proxies;
            this.tlsInfo = tlsInfo;
        }
        catch (BadGGEPPropertyException err) {
            throw new DHTValueException(err);
        }
        catch (BadGGEPBlockException err) {
            throw new DHTValueException(err);
        }
        catch (UnknownHostException err) {
            throw new DHTValueException(err);
        }
        catch (IOException err) {
            throw new DHTValueException(err);
        }
    }

    @Override
    public byte[] getValue() {
        byte[] copy = new byte[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        out.write(this.data);
    }

    @Override
    public byte[] getGUID() {
        return this.guid;
    }

    @Override
    public byte getFeatures() {
        return this.features;
    }

    @Override
    public int getFwtVersion() {
        return this.fwtVersion;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Set<? extends IpPort> getPushProxies() {
        return this.proxies;
    }

    @Override
    public BitNumbers getTLSInfo() {
        return this.tlsInfo;
    }
}

