/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.AsyncDimeWriter;
import com.limegroup.gnutella.dime.DIMERecord;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DIMEGenerator {
    private final List<DIMERecord> RECORDS = new LinkedList<DIMERecord>();
    private int _length = 0;

    public void add(DIMERecord record) {
        this.RECORDS.add(record);
        this._length += record.getRecordLength();
    }

    public int getLength() {
        return this._length;
    }

    public void write(OutputStream out) throws IOException {
        if (this.RECORDS.isEmpty()) {
            return;
        }
        Iterator<DIMERecord> iter = this.RECORDS.iterator();
        int size = this.RECORDS.size();
        for (int i = 0; i < size; ++i) {
            DIMERecord current = iter.next();
            if (i == 0) {
                current.setFirstRecord(true);
            } else {
                current.setFirstRecord(false);
            }
            if (i == size - 1) {
                current.setLastRecord(true);
            } else {
                current.setLastRecord(false);
            }
            current.write(out);
        }
    }

    public AsyncDimeWriter createAsyncWriter() {
        return new AsyncDimeWriter(this.RECORDS);
    }
}

