/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.DownloadSerializeSettings;
import com.limegroup.gnutella.downloader.serial.DownloadSerializer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;

@Singleton
public class DownloadSerializerImpl
implements DownloadSerializer {
    private static final Log LOG = LogFactory.getLog(DownloadSerializerImpl.class);
    private final DownloadSerializeSettings downloadSerializeSettings;

    @Inject
    public DownloadSerializerImpl(DownloadSerializeSettings downloadSerializeSettings) {
        this.downloadSerializeSettings = downloadSerializeSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadMemento> readFromDisk() throws IOException {
        Throwable exception;
        List<DownloadMemento> list;
        if (!this.downloadSerializeSettings.getSaveFile().exists() && !this.downloadSerializeSettings.getSaveFile().exists()) {
            return Collections.emptyList();
        }
        ConverterObjectInputStream in = null;
        try {
            in = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(this.downloadSerializeSettings.getSaveFile())));
            list = GenericsUtils.scanForList(in.readObject(), DownloadMemento.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable ignored) {
            try {
                exception = ignored;
                LOG.warn("Error reading normal file.", ignored);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(in);
            }
        }
        IOUtils.close(in);
        return list;
        try {
            in = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(this.downloadSerializeSettings.getBackupFile())));
            List<DownloadMemento> ignored = GenericsUtils.scanForList(in.readObject(), DownloadMemento.class, GenericsUtils.ScanMode.REMOVE);
            return ignored;
        }
        catch (Throwable ignored) {
            LOG.warn("Error reading normal file.", ignored);
        }
        finally {
            IOUtils.close(in);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw (IOException)new IOException().initCause(exception);
    }

    @Override
    public synchronized boolean writeToDisk(List<? extends DownloadMemento> mementos) {
        return FileUtils.writeWithBackupFile(mementos, this.downloadSerializeSettings.getBackupFile(), this.downloadSerializeSettings.getSaveFile(), LOG);
    }
}

