/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;

public class GreedyQueryFilter
implements SpamFilter {
    private static final int GREEDY_QUERY_MAX = 3;

    @Override
    public boolean allow(Message m) {
        if (!(m instanceof QueryRequest)) {
            return true;
        }
        QueryRequest qr = (QueryRequest)m;
        String query = qr.getQuery();
        int n = query.length();
        if (n == 1 && !qr.hasQueryUrns()) {
            return false;
        }
        if ((n == 5 || n == 6) && query.charAt(1) == '.' && Character.isLetter(query.charAt(0))) {
            return false;
        }
        if (this.isVeryGeneralSearch(query) || this.isObfuscatedGeneralSearch(query)) {
            byte hops = m.getHops();
            byte ttl = m.getTTL();
            if (hops >= 3) {
                return false;
            }
            if (hops + ttl > 3) {
                m.setTTL((byte)(3 - hops));
            }
        }
        return true;
    }

    private boolean isVeryGeneralSearch(String queryString) {
        int length = queryString.length();
        if (length == 3 && (queryString.charAt(1) == '.' || queryString.equalsIgnoreCase("mp3") || queryString.equalsIgnoreCase("mpg"))) {
            return true;
        }
        if (length == 5) {
            String fileFormat = queryString.substring(2, 5);
            if (queryString.charAt(1) == '.' && (fileFormat.equalsIgnoreCase("mp3") || fileFormat.equalsIgnoreCase("mpg"))) {
                return true;
            }
        }
        return false;
    }

    private boolean isObfuscatedGeneralSearch(String queryString) {
        String unacceptable = "*.- ";
        for (int i = 0; i < queryString.length(); ++i) {
            if ("*.- ".indexOf(queryString.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }
}

