/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.URNBlacklistManager;
import com.limegroup.gnutella.filters.URNFilter;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.spam.SpamManager;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.FilterSettings;
import org.limewire.util.Visitor;

@Singleton
class URNFilterImpl
implements URNFilter {
    private static final Log LOG = LogFactory.getLog(URNFilterImpl.class);
    private final SpamManager spamManager;
    private final URNBlacklistManager urnBlacklistManager;
    private final ScheduledExecutorService backgroundExecutor;
    private ImmutableSet<String> blacklist = null;

    @Inject
    URNFilterImpl(SpamManager spamManager, URNBlacklistManager urnBlacklistManager, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        this.spamManager = spamManager;
        this.urnBlacklistManager = urnBlacklistManager;
        this.backgroundExecutor = backgroundExecutor;
    }

    @Override
    public void refreshURNs(final SpamFilter.LoadCallback callback) {
        LOG.debug("Refreshing URN filter");
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final ImmutableSet.Builder<String> builder = ImmutableSet.builder();
                for (String s : FilterSettings.FILTERED_URNS_LOCAL.get()) {
                    builder.add(s);
                }
                if (FilterSettings.USE_NETWORK_FILTER.getValue()) {
                    for (String s : FilterSettings.FILTERED_URNS_REMOTE.get()) {
                        builder.add(s);
                    }
                }
                URNFilterImpl.this.urnBlacklistManager.loadURNs(new Visitor<String>(){

                    @Override
                    public boolean visit(String s) {
                        builder.add(s);
                        return true;
                    }
                });
                URNFilterImpl.this.blacklist = builder.build();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filter contains " + URNFilterImpl.this.blacklist.size() + " URNs");
                }
                if (callback != null) {
                    callback.spamFilterLoaded();
                }
            }
        });
    }

    @Override
    public boolean allow(Message m) {
        if (this.blacklist == null) {
            return true;
        }
        if (m instanceof QueryReply) {
            QueryReply q = (QueryReply)m;
            if (q.isBrowseHostReply()) {
                return true;
            }
            if (this.isBlacklisted(q)) {
                if (FilterSettings.FILTERED_URNS_ARE_SPAM.getValue()) {
                    this.spamManager.handleSpamQueryReply(q);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean allow(QueryReply q, Response r) {
        if (q.isBrowseHostReply()) {
            for (URN u : r.getUrns()) {
                if (!this.isBlacklisted(u)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isBlacklisted(QueryReply q) {
        if (this.blacklist == null) {
            return false;
        }
        try {
            for (Response r : q.getResultsArray()) {
                for (URN u : r.getUrns()) {
                    if (!this.isBlacklisted(u)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (BadPacketException bpe) {
            return true;
        }
    }

    @Override
    public boolean isBlacklisted(URN urn) {
        if (this.blacklist == null || urn == null) {
            return false;
        }
        if (this.blacklist.contains(urn.getNamespaceSpecificString())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(urn + " is spam");
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getBlacklist() {
        return this.blacklist;
    }
}

