/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeObserver;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeState;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.Properties;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.statemachine.IOState;
import org.limewire.nio.statemachine.IOStateMachine;
import org.limewire.nio.statemachine.IOStateObserver;

public class AsyncOutgoingHandshaker
implements Handshaker,
IOStateObserver {
    private static final Log LOG = LogFactory.getLog(AsyncOutgoingHandshaker.class);
    private final HandshakeSupport support;
    private final IOStateMachine shaker;
    private final Socket socket;
    private final HandshakeObserver observer;

    public AsyncOutgoingHandshaker(Properties requestHeaders, HandshakeResponder responder, Socket socket, HandshakeObserver observer) {
        this.socket = socket;
        this.support = new HandshakeSupport(socket.getInetAddress().getHostAddress());
        List<IOState> states = HandshakeState.getOutgoingHandshakeStates(this.support, requestHeaders, responder);
        this.shaker = new IOStateMachine(this, states);
        this.observer = observer;
    }

    @Override
    public void shake() throws SocketException {
        this.socket.setSoTimeout(8000);
        ((NIOMultiplexor)((Object)this.socket)).setReadObserver(this.shaker);
        ((NIOMultiplexor)((Object)this.socket)).setWriteObserver(this.shaker);
    }

    @Override
    public HandshakeResponse getWrittenHeaders() {
        return this.support.getWrittenHandshakeResponse();
    }

    @Override
    public HandshakeResponse getReadHeaders() {
        return this.support.getReadHandshakeResponse();
    }

    @Override
    public void handleStatesFinished() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished handshake with " + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort());
        }
        this.observer.handleHandshakeFinished(this);
    }

    @Override
    public void handleIOException(IOException iox) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(iox + ", " + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort());
        }
        if (iox instanceof NoGnutellaOkException) {
            NoGnutellaOkException ngok = (NoGnutellaOkException)iox;
            this.observer.handleNoGnutellaOk(ngok.getCode(), ngok.getMessage());
        } else {
            this.observer.handleBadHandshake();
        }
    }

    @Override
    public void shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down handshake with " + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort());
        }
        this.observer.shutdown();
    }
}

