/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.limewire.nio.statemachine.WriteState;
import org.limewire.statistic.Statistic;

public abstract class WriteHeadersIOState
extends WriteState {
    private ByteBuffer outgoing;
    private final Statistic stat;
    private long amountWritten;

    public WriteHeadersIOState(Statistic stat) {
        this.stat = stat;
    }

    @Override
    protected boolean processWrite(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        if (this.outgoing == null) {
            this.outgoing = this.createOutgoingData();
        }
        int written = channel.write(this.outgoing);
        if (this.stat != null) {
            this.stat.addData(written);
        }
        this.amountWritten += (long)written;
        if (!this.outgoing.hasRemaining()) {
            this.processWrittenHeaders();
            return false;
        }
        return true;
    }

    @Override
    public final long getAmountProcessed() {
        return this.amountWritten;
    }

    protected abstract ByteBuffer createOutgoingData() throws IOException;

    protected abstract void processWrittenHeaders() throws IOException;
}

