/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.IntSet;

class FileViewIterator
implements Iterator<FileDesc> {
    private final FileView fileList;
    private final IntSet.IntSetIterator iter;
    private FileDesc preview;

    public FileViewIterator(FileView fileList, IntSet intSet) {
        this.fileList = fileList;
        this.iter = intSet.iterator();
    }

    private boolean getPreview() {
        assert (this.preview == null);
        while (this.iter.hasNext() && this.preview == null) {
            this.preview = this.fileList.getFileDescForIndex(this.iter.next());
        }
        return this.preview != null;
    }

    @Override
    public boolean hasNext() {
        return this.preview != null || this.getPreview();
    }

    @Override
    public FileDesc next() {
        if (this.hasNext()) {
            FileDesc item = this.preview;
            this.preview = null;
            return item;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

