/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.inject.Inject;
import com.limegroup.gnutella.library.LibraryConverterHelper;
import com.limegroup.gnutella.library.LibraryFileData;
import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.library.OldLibraryData;
import com.limegroup.gnutella.library.OldLibrarySettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.setting.StringArraySetting;
import org.limewire.util.FileUtils;

class LibraryConverter {
    private final CategoryManager categoryManager;

    @Inject
    public LibraryConverter(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    boolean isOutOfDate() {
        return LibrarySettings.VERSION.get() == LibrarySettings.LibraryVersion.FOUR_X.name();
    }

    void convert(final LibraryFileData newData) {
        newData.revertToDefault();
        ArrayList<File> sharedFolders = new ArrayList<File>();
        ArrayList<File> excludedFolders = new ArrayList<File>();
        ArrayList<File> excludedFiles = new ArrayList<File>();
        ArrayList<String> extensions = new ArrayList<String>();
        OldLibraryData oldData = new OldLibraryData();
        Iterator<Object> i$ = OldLibrarySettings.DIRECTORIES_TO_SHARE.get().iterator();
        while (i$.hasNext()) {
            File folder = (File)i$.next();
            if (LibraryUtils.isSensitiveDirectory(folder) && !oldData.SENSITIVE_DIRECTORIES_VALIDATED.contains(folder)) continue;
            folder = FileUtils.canonicalize(folder);
            sharedFolders.add(folder);
        }
        excludedFolders.addAll(oldData.DIRECTORIES_NOT_TO_SHARE);
        for (File file : oldData.SPECIAL_FILES_TO_SHARE) {
            if (!this.addManagedFile(newData, file = FileUtils.canonicalize(file))) continue;
            newData.setFileInCollection(file, LibraryFileData.DEFAULT_SHARED_COLLECTION_ID, true);
        }
        for (File file : oldData.FILES_NOT_TO_SHARE) {
            file = FileUtils.canonicalize(file);
            excludedFiles.add(file);
        }
        extensions.addAll(Arrays.asList(OldLibrarySettings.getDefaultExtensions()));
        extensions.removeAll(Arrays.asList(StringArraySetting.decode(OldLibrarySettings.EXTENSIONS_LIST_UNSHARED.get())));
        extensions.addAll(Arrays.asList(StringArraySetting.decode(OldLibrarySettings.EXTENSIONS_LIST_CUSTOM.get())));
        HashSet<File> convertedDirectories = new HashSet<File>();
        this.convertSharedDirectories(sharedFolders, excludedFolders, excludedFiles, extensions, convertedDirectories, newData);
        for (File file : oldData.SPECIAL_STORE_FILES) {
            file = FileUtils.canonicalize(file);
            this.addManagedFile(newData, file);
        }
        LibraryConverterHelper helper = new LibraryConverterHelper(new LibraryConverterHelper.FileAdder(){

            @Override
            public void addFile(File file) {
                LibraryConverter.this.addManagedFile(newData, file);
            }
        }, this.categoryManager);
        helper.convertSaveDirectories(excludedFolders, excludedFiles, convertedDirectories);
        LibrarySettings.VERSION.set(LibrarySettings.LibraryVersion.FIVE_0_0.name());
        oldData.revertToDefault();
        OldLibrarySettings.DIRECTORIES_TO_SHARE.revertToDefault();
        OldLibrarySettings.DISABLE_SENSITIVE.revertToDefault();
        OldLibrarySettings.EXTENSIONS_LIST_CUSTOM.revertToDefault();
        OldLibrarySettings.EXTENSIONS_LIST_UNSHARED.revertToDefault();
        OldLibrarySettings.EXTENSIONS_TO_SHARE.revertToDefault();
    }

    private boolean addManagedFile(LibraryFileData newData, File file) {
        Category category = this.categoryManager.getCategoryForFile(file);
        if (category != Category.DOCUMENT && category != Category.PROGRAM) {
            newData.addManagedFile(file);
            return true;
        }
        return false;
    }

    private void convertSharedDirectories(List<File> sharedFolders, List<File> excludedFolders, List<File> excludedFiles, List<String> extensions, Set<File> convertedDirectories, final LibraryFileData data) {
        LibraryConverterHelper helper = new LibraryConverterHelper(new LibraryConverterHelper.FileAdder(){

            @Override
            public void addFile(File file) {
                if (LibraryConverter.this.addManagedFile(data, file)) {
                    data.setFileInCollection(file, LibraryFileData.DEFAULT_SHARED_COLLECTION_ID, true);
                }
            }
        }, this.categoryManager);
        for (File directory : sharedFolders) {
            helper.convertDirectory(directory, extensions, excludedFolders, excludedFiles, convertedDirectories, true);
        }
    }
}

