/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.library.FileDesc;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public class LibraryUtils {
    public static final File PROGRAM_SHARE;
    public static final File PREFERENCE_SHARE;
    public static final File APPLICATION_SPECIAL_SHARE;
    private static final List<File> userDirectories;
    private static final List<String> sensitiveDirectories;

    private static List<String> getUserDirectories(String directoryName) {
        ArrayList<String> userSubDirectories = new ArrayList<String>();
        for (File userHome : userDirectories) {
            File folder = new File(userHome, directoryName);
            userSubDirectories.add(folder.getAbsolutePath());
        }
        return userSubDirectories;
    }

    private static List<String> getSensitiveDirectories() {
        ArrayList<String> sensitiveDirectories = new ArrayList<String>();
        if (OSUtils.isWindows()) {
            sensitiveDirectories.addAll(LibraryUtils.getUserDirectories("Documents"));
            sensitiveDirectories.addAll(LibraryUtils.getUserDirectories("My Documents"));
            sensitiveDirectories.addAll(LibraryUtils.getUserDirectories("Desktop"));
            sensitiveDirectories.add(File.separator + "Documents and Settings");
            sensitiveDirectories.add(File.separator + "Program Files");
            sensitiveDirectories.add(File.separator + "Program Files (x86)");
            sensitiveDirectories.add(File.separator + "Windows");
            sensitiveDirectories.add(File.separator + "WINNT");
            sensitiveDirectories.add(File.separator + "Users");
            sensitiveDirectories.add(File.separator + "Local Settings");
            sensitiveDirectories.add(File.separator + "Temp");
            sensitiveDirectories.add(File.separator + "Temporary Internet Files");
            sensitiveDirectories.add(File.separator + "Program Data");
            sensitiveDirectories.add(File.separator + "ProgramData");
            sensitiveDirectories.add(File.separator + "Application Data");
            sensitiveDirectories.add(File.separator + "AppData");
            sensitiveDirectories.add(File.separator + "Windows" + File.separator + "System");
            sensitiveDirectories.add(File.separator + "Windows" + File.separator + "System32");
        }
        if (OSUtils.isMacOSX()) {
            sensitiveDirectories.addAll(LibraryUtils.getUserDirectories("Documents"));
            sensitiveDirectories.addAll(LibraryUtils.getUserDirectories("Desktop"));
            sensitiveDirectories.addAll(LibraryUtils.getUserDirectories("Library"));
            sensitiveDirectories.add(File.separator + "Users");
            sensitiveDirectories.add(File.separator + "System");
            sensitiveDirectories.add(File.separator + "System Folder");
            sensitiveDirectories.add(File.separator + "Previous Systems");
            sensitiveDirectories.add(File.separator + "private");
            sensitiveDirectories.add(File.separator + "Volumes");
            sensitiveDirectories.add(File.separator + "Desktop");
            sensitiveDirectories.add(File.separator + "Applications");
            sensitiveDirectories.add(File.separator + "Applications (Mac OS 9)");
            sensitiveDirectories.add(File.separator + "Network");
        }
        if (OSUtils.isPOSIX()) {
            sensitiveDirectories.addAll(LibraryUtils.getUserDirectories("Desktop"));
            sensitiveDirectories.addAll(LibraryUtils.getUserDirectories("Documents"));
            sensitiveDirectories.add(File.separator + "bin");
            sensitiveDirectories.add(File.separator + "boot");
            sensitiveDirectories.add(File.separator + "dev");
            sensitiveDirectories.add(File.separator + "etc");
            sensitiveDirectories.add(File.separator + "home");
            sensitiveDirectories.add(File.separator + "mnt");
            sensitiveDirectories.add(File.separator + "opt");
            sensitiveDirectories.add(File.separator + "proc");
            sensitiveDirectories.add(File.separator + "root");
            sensitiveDirectories.add(File.separator + "sbin");
            sensitiveDirectories.add(File.separator + "usr");
            sensitiveDirectories.add(File.separator + "var");
            sensitiveDirectories.add(File.separator + "lib");
            sensitiveDirectories.add(File.separator + "sys");
            sensitiveDirectories.add(File.separator + "cdrom");
        }
        return sensitiveDirectories;
    }

    private static List<File> getUserDirectories() {
        File[] directories;
        File userHome = new File(System.getProperty("user.home"));
        ArrayList<File> userDirectories = new ArrayList<File>();
        userDirectories.add(userHome.getAbsoluteFile());
        File commonHome = null;
        if (OSUtils.isWindowsVista() || OSUtils.isWindows7()) {
            commonHome = new File("C:/Users");
        } else if (OSUtils.isWindows()) {
            commonHome = new File("C:/Documents and Settings");
        } else if (OSUtils.isMacOSX()) {
            commonHome = new File("/Users");
        } else if (OSUtils.isLinux()) {
            commonHome = new File("/home");
        }
        if (commonHome != null && (directories = commonHome.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null) {
            userDirectories.addAll(Arrays.asList(directories));
        }
        return userDirectories;
    }

    public static boolean isFileManagable(File file, CategoryManager categoryManager) {
        return LibraryUtils.isFilePhysicallyManagable(file) && LibraryUtils.isFileAllowedToBeManaged(file, categoryManager);
    }

    public static boolean isFilePhysicallyManagable(File file) {
        if (file == null || !file.exists() || file.isDirectory() || !file.canRead() || file.isHidden()) {
            return false;
        }
        long fileLength = file.length();
        return fileLength > 0L && fileLength <= 0xFFFFFFFFFFL;
    }

    public static boolean isFileAllowedToBeManaged(File file, CategoryManager categoryManager) {
        Category category;
        return LibrarySettings.ALLOW_PROGRAMS.getValue() || LibraryUtils.isForcedShare(file) || (category = categoryManager.getCategoryForFile(file)) != Category.PROGRAM;
    }

    public static boolean isSensitiveDirectory(File folder) {
        if (folder == null) {
            return false;
        }
        if (userDirectories.contains(folder)) {
            return true;
        }
        String folderPath = folder.getPath().toUpperCase();
        for (String name : sensitiveDirectories) {
            if (!folderPath.endsWith(name.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isForcedShare(FileDesc desc) {
        return LibraryUtils.isForcedShare(desc.getFile());
    }

    public static boolean isForcedShare(File file) {
        File parent = file.getParentFile();
        return parent != null && LibraryUtils.isForcedShareDirectory(parent);
    }

    public static boolean isApplicationSpecialShare(File file) {
        File parent = file.getParentFile();
        return parent != null && LibraryUtils.isApplicationSpecialShareDirectory(parent);
    }

    public static boolean isForcedShareDirectory(File f) {
        return f != null && (f.equals(PROGRAM_SHARE) || f.equals(PREFERENCE_SHARE));
    }

    public static boolean isApplicationSpecialShareDirectory(File directory) {
        return directory.equals(APPLICATION_SPECIAL_SHARE);
    }

    public static boolean isFolderBanned(File folder) {
        String parent;
        String name;
        File[] faRoots = File.listRoots();
        if (faRoots != null && faRoots.length > 0) {
            for (int i = 0; i < faRoots.length; ++i) {
                if (!folder.equals(faRoots[i])) continue;
                return true;
            }
        }
        if ((name = folder.getName().toLowerCase(Locale.US)).equals("cookies")) {
            return true;
        }
        return name.equals("low") && (parent = folder.getParent()) != null && parent.toLowerCase(Locale.US).equals("cookies");
    }

    static {
        File forceShare = new File(".", ".NetworkShare").getAbsoluteFile();
        try {
            forceShare = FileUtils.getCanonicalFile(forceShare);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        PROGRAM_SHARE = forceShare;
        forceShare = new File(CommonUtils.getUserSettingsDir(), ".NetworkShare").getAbsoluteFile();
        try {
            forceShare = FileUtils.getCanonicalFile(forceShare);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        PREFERENCE_SHARE = forceShare;
        forceShare = new File(CommonUtils.getUserSettingsDir(), ".AppSpecialShare").getAbsoluteFile();
        forceShare.mkdir();
        try {
            forceShare = FileUtils.getCanonicalFile(forceShare);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        APPLICATION_SPECIAL_SHARE = forceShare;
        userDirectories = LibraryUtils.getUserDirectories();
        sensitiveDirectories = LibraryUtils.getSensitiveDirectories();
    }
}

