/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.MutableLicense;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.limewire.http.httpclient.LimeHttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractLicense
implements MutableLicense,
Serializable,
Cloneable {
    private static final Log LOG = LogFactory.getLog(AbstractLicense.class);
    private static final long serialVersionUID = 6508972367931096578L;
    protected transient int verified = 0;
    protected transient URI licenseLocation;
    private transient String licenseName;
    private long lastVerifiedTime;

    AbstractLicense(URI uri) {
        this.licenseLocation = uri;
    }

    @Override
    public void setLicenseName(String name) {
        this.licenseName = name;
    }

    @Override
    public boolean isVerifying() {
        return this.verified == 1;
    }

    @Override
    public boolean isVerified() {
        return this.verified == 2;
    }

    @Override
    public String getLicenseName() {
        return this.licenseName;
    }

    @Override
    public URI getLicenseURI() {
        return this.licenseLocation;
    }

    @Override
    public long getLastVerifiedTime() {
        return this.lastVerifiedTime;
    }

    void setVerified(int verified) {
        this.verified = verified;
    }

    void setLastVerifiedTime(long lastVerifiedTime) {
        this.lastVerifiedTime = lastVerifiedTime;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.verified = 2;
    }

    protected abstract void clear();

    protected String getBody(String url, LimeHttpClient httpClient) {
        return this.getBodyFromURL(url, httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBodyFromURL(String url, LimeHttpClient httpClient) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Contacting: " + url);
        }
        HttpResponse response = null;
        try {
            HttpGet get = new HttpGet(url);
            get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
            response = httpClient.execute(get);
            String result = response.getEntity() != null ? EntityUtils.toString(response.getEntity()) : null;
            String string = result;
            httpClient.releaseConnection(response);
            return string;
        }
        catch (IOException e) {
            try {
                LOG.warn("Can't contact license server: " + url, e);
                httpClient.releaseConnection(response);
            }
            catch (Throwable throwable) {
                httpClient.releaseConnection(response);
                throw throwable;
            }
        }
        return null;
    }

    protected abstract void parseDocumentNode(Node var1, LicenseCache var2, LimeHttpClient var3);

    protected void parseXML(String xml, LicenseCache licenseCache, LimeHttpClient httpClient) {
        Document d;
        if (xml == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to parse: " + xml);
        }
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            d = parser.parse(is);
        }
        catch (IOException ioe) {
            LOG.debug("IOX parsing XML\n" + xml, ioe);
            return;
        }
        catch (SAXException saxe) {
            LOG.debug("SAX parsing XML\n" + xml, saxe);
            return;
        }
        catch (ParserConfigurationException bad) {
            LOG.debug("couldn't instantiate parser", bad);
            return;
        }
        this.parseDocumentNode(d.getDocumentElement(), licenseCache, httpClient);
    }

    @Override
    public void verify(LicenseCache licenseCache, LimeHttpClient httpClient) {
        this.setVerified(1);
        this.clear();
        String body = this.getBody(this.getLicenseURI().toString(), httpClient);
        this.parseXML(body, licenseCache, httpClient);
        this.setLastVerifiedTime(System.currentTimeMillis());
        this.setVerified(2);
        licenseCache.addVerifiedLicense(this);
    }
}

