/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.malware;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.Scanner;
import org.limewire.collection.SortedList;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

public class NFOFile {
    private static final Log LOG = LogFactory.getLog(NFOFile.class);
    private SortedList<Entry> incrementalEntries = new SortedList<Entry>(new EntryComparator());
    private SortedList<Entry> fullEntries = new SortedList<Entry>(new EntryComparator());

    public NFOFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        while (scanner.hasNextLine()) {
            String[] words;
            String line = scanner.nextLine();
            if (line.startsWith("#") || line.startsWith("!") || (words = line.split(":")).length != 2) continue;
            words[0] = words[0].trim();
            words[1] = words[1].trim();
            String name = words[1];
            int extIndex = name.lastIndexOf(46);
            if (extIndex <= -1 || (name = name.substring(0, extIndex)).length() < 4) continue;
            try {
                int version = Integer.valueOf(name.substring(name.length() - 4));
                if (words[0].equals("IVDB")) {
                    this.incrementalEntries.add(new Entry(words[1], version));
                    continue;
                }
                if (!words[0].equals("VDB")) continue;
                this.fullEntries.add(new Entry(words[1], version));
            }
            catch (NumberFormatException nfe) {
                LOG.debug("unable to parse version", nfe);
            }
        }
        scanner.close();
    }

    public SortedList<Entry> getIncrementalEntries() {
        return this.incrementalEntries;
    }

    public SortedList<Entry> getFullEntries() {
        return this.fullEntries;
    }

    public static class EntryComparator
    implements Comparator<Entry> {
        @Override
        public int compare(Entry o1, Entry o2) {
            return o1.compareTo(o2);
        }
    }

    public class Entry
    implements Comparable<Entry> {
        private final String path;
        private final Integer version;

        public Entry(String path, Integer version) {
            this.path = path;
            this.version = version;
        }

        public String getPath() {
            return this.path;
        }

        public int getVersion() {
            return this.version;
        }

        @Override
        public int compareTo(Entry o) {
            return this.version.compareTo(o.version);
        }
    }
}

