/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.malware;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.malware.NFOFile;
import com.limegroup.gnutella.malware.VirusDefinitionDownloadMemento;
import com.limegroup.gnutella.malware.VirusDefinitionDownloader;
import com.limegroup.gnutella.malware.VirusDefinitionHandler;
import com.limegroup.gnutella.malware.VirusDefinitionManager;
import com.limegroup.gnutella.malware.VirusScanException;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.malware.VirusUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.collection.SortedList;
import org.limewire.core.api.malware.VirusUpdatesURL;
import org.limewire.core.settings.FilterSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Expand;
import org.limewire.io.InvalidDataException;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Join;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

@EagerSingleton
class VirusDefinitionManagerImpl
implements VirusDefinitionManager,
Service {
    private static final Log LOG = LogFactory.getLog(VirusDefinitionManagerImpl.class);
    private static final int MAX_RETRIES = 2;
    private final File mementoFile = new File(CommonUtils.getUserSettingsDir(), "vdef.dat");
    private final File mementoBackupFile = new File(CommonUtils.getUserHomeDir(), "vdef.bak");
    private final Provider<VirusDefinitionDownloader> downloaderFactory;
    private final Provider<VirusScanner> virusScannerProvider;
    private final Provider<String> updatesURL;
    private final ScheduledExecutorService backgroundExecutor;
    private final AtomicBoolean checking;
    private int retries = 0;

    @Inject
    VirusDefinitionManagerImpl(Provider<VirusDefinitionDownloader> downloader, Provider<VirusScanner> virusScanner, @VirusUpdatesURL Provider<String> updatesURL, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        LOG.debug("Creating VirusDefinitionManagerImpl");
        this.downloaderFactory = downloader;
        this.virusScannerProvider = virusScanner;
        this.updatesURL = updatesURL;
        this.backgroundExecutor = backgroundExecutor;
        this.checking = new AtomicBoolean(false);
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return "Virus Definition Service";
    }

    @Override
    public void initialize() {
    }

    @Override
    @Asynchronous(join=Join.NONE)
    public void start() {
        LOG.debug("Starting Virus Definition Checking..");
        VirusScanner scanner = this.virusScannerProvider.get();
        if (this.isScanningAllowed()) {
            LOG.debug("Virus scanner is supported!");
            VirusDefinitionDownloadMemento memento = this.loadMemento();
            if (memento == null) {
                LOG.debug("No memento exists, starting as normal.");
                this.fetchNfo(null);
            } else if (scanner.getDefinitionsVersion() == 0) {
                LOG.debug("No loaded database, continuing from memento...");
                try {
                    this.startMementoDownload(memento, false);
                }
                catch (InvalidDataException ide) {
                    LOG.debug("Invalid memento, starting full check", ide);
                    this.eraseMementos(memento);
                    this.fetchNfo(null);
                }
            } else {
                LOG.debug("Database is loaded, checking NFO to see if we should continue...");
                this.fetchNfo(memento);
            }
        }
    }

    @Override
    public void stop() {
    }

    private boolean isScanningAllowed() {
        if (!this.virusScannerProvider.get().isSupported()) {
            LOG.debug("Not supported");
            return false;
        }
        if (LimeWireUtils.isTemporaryDirectoryInUse()) {
            LOG.debug("Won't use a temporary directory");
            return false;
        }
        if (!FilterSettings.CHECK_FOR_VIRUS_DEFINITION_UPDATES.getValue()) {
            LOG.debug("Checking for virus definition updates is disabled");
            return false;
        }
        return true;
    }

    VirusDefinitionDownloadMemento loadMemento() {
        if (!this.mementoFile.exists()) {
            LOG.debug("No memento file exists, unable to load a memento");
            return null;
        }
        try {
            Object read = FileUtils.readObject(this.mementoFile);
            if (read instanceof VirusDefinitionDownloadMemento) {
                VirusDefinitionDownloadMemento memento = (VirusDefinitionDownloadMemento)read;
                LOG.debugf("Loaded memento file {0}", (Object)memento);
                if (memento.getHandlerType() == VirusDefinitionHandler.HandlerType.FULL && memento.getIncompleteFile() != null && memento.getIncompleteFile().exists() && memento.getUri() != null) {
                    return memento;
                }
                this.eraseMementos(memento);
                return null;
            }
        }
        catch (Throwable t) {
            LOG.error("Error reading memento file", t);
        }
        this.eraseMementos(null);
        return null;
    }

    private void eraseMementos(VirusDefinitionDownloadMemento memento) {
        if (memento != null && memento.getIncompleteFile() != null) {
            memento.getIncompleteFile().delete();
        }
        this.mementoFile.delete();
        this.mementoBackupFile.delete();
    }

    private void downloadFinished() {
        this.eraseMementos(null);
    }

    @Override
    public void checkForDefinitions() {
        this.fetchNfo(null);
    }

    private void startMementoDownload(VirusDefinitionDownloadMemento memento, boolean alreadyChecking) throws InvalidDataException {
        assert (memento.getHandlerType() == VirusDefinitionHandler.HandlerType.FULL);
        VirusDefinitionDownloader downloader = this.downloaderFactory.get();
        try {
            downloader.initFromMemento(memento);
        }
        catch (Throwable t) {
            throw new InvalidDataException("Invalid memento!", t);
        }
        if (alreadyChecking) {
            assert (this.checking.get());
        } else {
            boolean wasChecking = this.checking.getAndSet(true);
            assert (!wasChecking);
        }
        downloader.fetch(new FullUpdateHandler(true), this.mementoFile, this.mementoBackupFile);
    }

    private void fetchNfo(VirusDefinitionDownloadMemento memento) {
        if (this.checking.getAndSet(true)) {
            LOG.debug("Already checking");
            return;
        }
        try {
            URI nfo = new URI(this.updatesURL.get() + "current.nfo");
            VirusDefinitionDownloader downloader = this.downloaderFactory.get();
            downloader.setUriAndName(nfo, "current.nfo");
            downloader.fetch(new NFOHandler(memento), null, null);
        }
        catch (URISyntaxException e) {
            LOG.debug("Invalid URI for current.nfo", e);
            this.scheduleNextCheck();
        }
    }

    private void doFullUpdate(NFOFile nfoFile, int currentVersion, VirusDefinitionDownloadMemento memento) {
        SortedList<NFOFile.Entry> fullEntries = nfoFile.getFullEntries();
        if (fullEntries.last().getVersion() > currentVersion) {
            NFOFile.Entry latestFullEntry = nfoFile.getFullEntries().last();
            try {
                URI fullUpdate = new URI(this.updatesURL.get() + latestFullEntry.getPath());
                if (memento != null && fullUpdate.equals(memento.getUri())) {
                    try {
                        this.startMementoDownload(memento, true);
                        return;
                    }
                    catch (InvalidDataException ignored) {
                        this.eraseMementos(memento);
                    }
                }
                VirusDefinitionDownloader downloader = this.downloaderFactory.get();
                downloader.setUriAndName(fullUpdate, latestFullEntry.getPath());
                downloader.fetch(new FullUpdateHandler(false), this.mementoFile, this.mementoBackupFile);
            }
            catch (URISyntaxException e) {
                LOG.debug("Invalid full update URI", e);
                this.scheduleNextCheck();
            }
        }
    }

    private void doIncrementalOrFullUpdate(NFOFile nfoFile, VirusDefinitionDownloadMemento memento) {
        int currentVersion = this.virusScannerProvider.get().getDefinitionsVersion();
        if (currentVersion == 0) {
            this.doFullUpdate(nfoFile, currentVersion, memento);
            return;
        }
        SortedList<NFOFile.Entry> incrementalEntries = nfoFile.getIncrementalEntries();
        if (incrementalEntries.last().getVersion() <= currentVersion) {
            LOG.debug("Virus definitions are up to date");
            this.scheduleNextCheck();
            return;
        }
        if (incrementalEntries.first().getVersion() > currentVersion + 1) {
            this.doFullUpdate(nfoFile, currentVersion, memento);
            return;
        }
        this.eraseMementos(memento);
        SortedList<NFOFile.Entry> newIncrementalEntries = new SortedList<NFOFile.Entry>(new NFOFile.EntryComparator());
        for (NFOFile.Entry entry : incrementalEntries) {
            if (entry.getVersion() <= currentVersion) continue;
            newIncrementalEntries.add(entry);
        }
        IncrementalUpdateHandler incrementalUpdateHandler = new IncrementalUpdateHandler(newIncrementalEntries);
        incrementalUpdateHandler.downloadNext();
    }

    private boolean isUpdateCompatibleWithLibrary(File updateDir) throws IOException {
        String library = this.virusScannerProvider.get().getLibraryVersion();
        LOG.debugf("Library version: {0}", (Object)library);
        int[] lib = this.parseVersion(library);
        File nfo = new File(updateDir, "version.nfo");
        String required = VirusUtils.getNfoValue(nfo, "REQUIRED_BIN_RELEASE_VERSION");
        LOG.debugf("Required version: {0}", (Object)required);
        int[] req = this.parseVersion(required);
        for (int i = 0; i < 3; ++i) {
            if (lib[i] > req[i]) {
                return true;
            }
            if (lib[i] >= req[i]) continue;
            return false;
        }
        return true;
    }

    private int[] parseVersion(String version) throws IOException {
        String[] strings = version.split("\\.");
        if (strings.length != 3) {
            throw new IOException("Invalid version: " + version);
        }
        int[] ints = new int[3];
        try {
            for (int i = 0; i < 3; ++i) {
                ints[i] = Integer.parseInt(strings[i]);
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid version: " + version, e);
        }
        return ints;
    }

    private void scheduleNextCheck() {
        this.checking.set(false);
        Runnable check = new Runnable(){

            @Override
            public void run() {
                VirusDefinitionManagerImpl.this.fetchNfo(null);
            }
        };
        LOG.debug("Scheduling next check in 24 hours");
        this.backgroundExecutor.schedule(check, 24L, TimeUnit.HOURS);
    }

    private void considerRetrying() {
        if (this.retries++ < 2) {
            LOG.debug("Retrying");
            this.fetchNfo(null);
        } else {
            LOG.debug("Not retrying");
            this.retries = 0;
            this.scheduleNextCheck();
        }
    }

    private class NFOHandler
    implements VirusDefinitionHandler {
        private final VirusDefinitionDownloadMemento memento;

        public NFOHandler(VirusDefinitionDownloadMemento memento) {
            this.memento = memento;
        }

        @Override
        public void downloadSucceeded(File nfo) {
            VirusDefinitionManagerImpl.this.downloadFinished();
            try {
                NFOFile nfoFile = new NFOFile(nfo);
                VirusDefinitionManagerImpl.this.doIncrementalOrFullUpdate(nfoFile, this.memento);
            }
            catch (FileNotFoundException e) {
                LOG.debugf(e, "Unable to load file {0}", nfo);
                VirusDefinitionManagerImpl.this.scheduleNextCheck();
            }
        }

        @Override
        public void downloadFailed(File incomplete) {
            VirusDefinitionManagerImpl.this.downloadFinished();
            LOG.debug("Unable to download nfo file");
            VirusDefinitionManagerImpl.this.scheduleNextCheck();
        }

        @Override
        public VirusDefinitionHandler.HandlerType getHandlerType() {
            return VirusDefinitionHandler.HandlerType.NFO;
        }
    }

    private class IncrementalUpdateHandler
    implements VirusDefinitionHandler {
        private final SortedList<NFOFile.Entry> incrementalEntries;

        public IncrementalUpdateHandler(SortedList<NFOFile.Entry> incrementalEntries) {
            this.incrementalEntries = incrementalEntries;
        }

        @Override
        public VirusDefinitionHandler.HandlerType getHandlerType() {
            return VirusDefinitionHandler.HandlerType.INCREMENTAL;
        }

        private void downloadNext() {
            if (this.incrementalEntries.size() > 0) {
                try {
                    NFOFile.Entry entry = (NFOFile.Entry)this.incrementalEntries.remove(0);
                    this.download(entry);
                }
                catch (URISyntaxException e) {
                    LOG.debug("Invalid incremental update URI", e);
                    VirusDefinitionManagerImpl.this.scheduleNextCheck();
                }
            }
        }

        private void download(NFOFile.Entry entry) throws URISyntaxException {
            URI incrementalUpdate = new URI((String)VirusDefinitionManagerImpl.this.updatesURL.get() + entry.getPath());
            VirusDefinitionDownloader downloader = (VirusDefinitionDownloader)VirusDefinitionManagerImpl.this.downloaderFactory.get();
            downloader.setUriAndName(incrementalUpdate, entry.getPath());
            downloader.fetch(this, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadSucceeded(File defs) {
            VirusDefinitionManagerImpl.this.downloadFinished();
            boolean startFromScratch = false;
            File temp = VirusUtils.getTemporaryDirectory();
            FileUtils.forceDeleteRecursive(temp);
            temp.mkdirs();
            temp.mkdir();
            try {
                Expand.expandFile(defs, temp, true);
                String name = FileUtils.getFilenameNoExtension(defs.getName());
                File updateDir = new File(temp, name);
                if (!updateDir.exists()) {
                    throw new IOException("Unexpected zip format");
                }
                if (!VirusDefinitionManagerImpl.this.isUpdateCompatibleWithLibrary(updateDir)) {
                    FilterSettings.CHECK_FOR_VIRUS_DEFINITION_UPDATES.set(false);
                    throw new IOException("Update is not compatible with library");
                }
                ((VirusScanner)VirusDefinitionManagerImpl.this.virusScannerProvider.get()).loadIncrementalUpdate(updateDir);
                this.downloadNext();
            }
            catch (IOException e) {
                LOG.debug("Error expanding or loading incremental update", e);
            }
            catch (VirusScanException e) {
                LOG.debug("Error loading incremental update", e);
                FileUtils.forceDeleteRecursive(VirusUtils.getDatabaseDirectory());
                startFromScratch = true;
            }
            finally {
                FileUtils.forceDeleteRecursive(temp);
            }
            VirusDefinitionManagerImpl.this.checking.set(false);
            if (startFromScratch) {
                VirusDefinitionManagerImpl.this.considerRetrying();
            }
        }

        @Override
        public void downloadFailed(File incomplete) {
            VirusDefinitionManagerImpl.this.downloadFinished();
            LOG.debug("Unable to download incremental update");
            VirusDefinitionManagerImpl.this.scheduleNextCheck();
        }
    }

    private class FullUpdateHandler
    implements VirusDefinitionHandler {
        private final boolean fromMemento;

        FullUpdateHandler(boolean fromMemento) {
            this.fromMemento = fromMemento;
        }

        @Override
        public VirusDefinitionHandler.HandlerType getHandlerType() {
            return VirusDefinitionHandler.HandlerType.FULL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadSucceeded(File defs) {
            VirusDefinitionManagerImpl.this.downloadFinished();
            boolean startFromScratch = false;
            File temp = VirusUtils.getTemporaryDirectory();
            FileUtils.forceDeleteRecursive(temp);
            temp.mkdirs();
            temp.mkdir();
            try {
                Expand.expandFile(defs, temp, true);
                String name = FileUtils.getFilenameNoExtension(defs.getName());
                File updateDir = new File(temp, name);
                if (!updateDir.exists()) {
                    throw new IOException("Unexpected zip format");
                }
                if (!VirusDefinitionManagerImpl.this.isUpdateCompatibleWithLibrary(updateDir)) {
                    FilterSettings.CHECK_FOR_VIRUS_DEFINITION_UPDATES.set(false);
                    throw new IOException("Update is not compatible with library");
                }
                ((VirusScanner)VirusDefinitionManagerImpl.this.virusScannerProvider.get()).loadFullUpdate(updateDir);
                if (this.fromMemento) {
                    VirusDefinitionManagerImpl.this.fetchNfo(null);
                }
            }
            catch (IOException e) {
                LOG.debug("Error expanding full update", e);
                if (((VirusScanner)VirusDefinitionManagerImpl.this.virusScannerProvider.get()).getDefinitionsVersion() == 0) {
                    startFromScratch = true;
                }
            }
            catch (VirusScanException e) {
                LOG.debug("Error loading full update", e);
                FileUtils.forceDeleteRecursive(VirusUtils.getDatabaseDirectory());
                startFromScratch = true;
            }
            finally {
                FileUtils.forceDeleteRecursive(temp);
            }
            VirusDefinitionManagerImpl.this.checking.set(false);
            if (startFromScratch) {
                VirusDefinitionManagerImpl.this.considerRetrying();
            }
        }

        @Override
        public void downloadFailed(File incomplete) {
            VirusDefinitionManagerImpl.this.downloadFinished();
            LOG.debug("Unable to download full update");
            if (this.fromMemento) {
                VirusDefinitionManagerImpl.this.considerRetrying();
            } else {
                VirusDefinitionManagerImpl.this.scheduleNextCheck();
            }
        }
    }
}

