/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.io.GUID;
import org.limewire.util.ByteUtils;

public final class QueryStatusResponse
extends AbstractVendorMessage {
    public static final int VERSION = 1;

    QueryStatusResponse(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_BEAR_VENDOR_ID, 12, version, payload, network);
        if (this.getVersion() > 1) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 2) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
    }

    public QueryStatusResponse(GUID replyGUID, int numResults) {
        super(F_BEAR_VENDOR_ID, 12, 1, QueryStatusResponse.derivePayload(numResults));
        this.setGUID(replyGUID);
    }

    public int getNumResults() {
        return ByteUtils.ushort2int(ByteUtils.leb2short(this.getPayload(), 0));
    }

    public GUID getQueryGUID() {
        return new GUID(this.getGUID());
    }

    private static byte[] derivePayload(int numResults) {
        if (numResults < 0 || numResults > 65535) {
            throw new IllegalArgumentException("Number of results too big: " + numResults);
        }
        byte[] payload = new byte[2];
        ByteUtils.short2leb((short)numResults, payload, 0);
        return payload;
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }
}

