/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.core.settings.SearchSettings;
import org.limewire.io.GUID;
import org.limewire.util.ByteUtils;

public final class ReplyNumberVendorMessage
extends AbstractVendorMessage {
    public static final int OLD_VERSION = 2;
    public static final int VERSION = 3;
    protected static final byte UNSOLICITED = 1;

    ReplyNumberVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 12, version, payload, network);
        if (version < 2) {
            throw new BadPacketException("ancient version");
        }
        if (version < 3) {
            if (SearchSettings.DISABLE_OOB_V2.getBoolean()) {
                throw new BadPacketException("OOB v2 not allowed");
            }
            if (this.getPayload().length != 2) {
                throw new BadPacketException("v2 message too large");
            }
        }
        if (this.getPayload().length < 2) {
            throw new BadPacketException("VERSION " + version + " UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
    }

    ReplyNumberVendorMessage(GUID replyGUID, int version, int numResults, boolean canReceiveUnsolicited) {
        super(F_LIME_VENDOR_ID, 12, version, ReplyNumberVendorMessage.derivePayload(numResults, canReceiveUnsolicited));
        this.setGUID(replyGUID);
    }

    private static byte[] derivePayload(int numResults, boolean canReceiveUnsolicited) {
        if (numResults < 1 || numResults > 255) {
            throw new IllegalArgumentException("Number of results too big: " + numResults);
        }
        byte[] bytes = new byte[2];
        ByteUtils.short2leb((short)numResults, bytes, 0);
        bytes[1] = canReceiveUnsolicited ? (byte)1 : 0;
        return bytes;
    }

    public int getNumResults() {
        return ByteUtils.ubyte2int(this.getPayload()[0]);
    }

    public boolean canReceiveUnsolicited() {
        if (this.getVersion() == 1) {
            return true;
        }
        return (this.getPayload()[1] & 1) == 1;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ReplyNumberVendorMessage) {
            GUID myGuid = new GUID(this.getGUID());
            GUID otherGuid = new GUID(((VendorMessage)other).getGUID());
            int otherResults = ((ReplyNumberVendorMessage)other).getNumResults();
            return myGuid.equals(otherGuid) && this.getNumResults() == otherResults && super.equals(other);
        }
        return false;
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }

    public boolean isOOBv3() {
        return this.getVersion() == 3;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(", num results: ").append(this.getNumResults());
        builder.append(", canReceiveUnsolicited:").append(this.canReceiveUnsolicited());
        return builder.toString();
    }
}

