/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.limewire.io.GUID;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

public final class UDPConnectBackRedirect
extends AbstractVendorMessage {
    public static final int VERSION = 1;
    private final int _port;
    private final InetAddress _addr;

    UDPConnectBackRedirect(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 8, version, payload, network);
        if (this.getVersion() == 1 && this.getPayload().length != 6) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + payload.length);
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.getPayload(), 0, ip, 0, ip.length);
        if (!NetworkUtils.isValidAddress(ip)) {
            throw new BadPacketException("Bad Host!!");
        }
        try {
            this._addr = InetAddress.getByName(NetworkUtils.ip2string(ip));
        }
        catch (UnknownHostException uhe) {
            throw new BadPacketException("Bad InetAddress!!");
        }
        this._port = ByteUtils.ushort2int(ByteUtils.leb2short(this.getPayload(), ip.length));
        if (!NetworkUtils.isValidPort(this._port)) {
            throw new BadPacketException("invalid port");
        }
    }

    public UDPConnectBackRedirect(GUID guid, InetAddress addr, int port) {
        super(F_LIME_VENDOR_ID, 8, 1, UDPConnectBackRedirect.derivePayload(addr, port));
        this.setGUID(guid);
        this._addr = addr;
        this._port = port;
    }

    public GUID getConnectBackGUID() {
        return new GUID(this.getGUID());
    }

    public InetAddress getConnectBackAddress() {
        return this._addr;
    }

    public int getConnectBackPort() {
        return this._port;
    }

    private static byte[] derivePayload(InetAddress addr, int port) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] ip = addr.getAddress();
            if (!NetworkUtils.isValidAddress(ip)) {
                throw new IllegalArgumentException("invalid addr: " + addr);
            }
            baos.write(ip);
            ByteUtils.short2leb((short)port, baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }
}

