/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.reader;

import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.metadata.audio.reader.AudioDataReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;

public class MP3Reader
extends AudioDataReader {
    private static final String STORE_OPTIONS_KEY = "store+options@limewire.com";
    private static final String OVERRIDE_KEY = "override_allowed";
    private boolean isStoreFile = false;
    private boolean isShareable = false;

    @Override
    protected void readTag(AudioMetaData audioData, AudioFile audioFile, Tag tag) {
        this.isStoreFile = false;
        this.isShareable = false;
        MP3File mp3File = (MP3File)audioFile;
        mp3File.getID3v1Tag();
        AbstractID3v2Tag v2Tag = mp3File.getID3v2Tag();
        ID3v1Tag v1Tag = mp3File.getID3v1Tag();
        if (v2Tag != null) {
            this.readV2Tag(audioData, v2Tag);
        }
        if (v1Tag != null) {
            this.readV1Tag(audioData, v1Tag);
        }
    }

    private void readV1Tag(AudioMetaData audioData, ID3v1Tag tag) {
        if (audioData.getTitle() == null || audioData.getTitle().length() == 0) {
            audioData.setTitle(tag.getFirstTitle());
        }
        if (audioData.getArtist() == null || audioData.getArtist().length() == 0) {
            audioData.setArtist(tag.getFirstArtist());
        }
        if (audioData.getAlbum() == null || audioData.getAlbum().length() == 0) {
            audioData.setAlbum(tag.getFirstAlbum());
        }
        if (audioData.getYear() == null || audioData.getYear().length() == 0) {
            audioData.setYear(tag.getFirstYear());
        }
        if (audioData.getComment() == null || audioData.getComment().length() == 0) {
            audioData.setComment(tag.getFirstComment());
        }
        if (audioData.getGenre() == null || audioData.getGenre().length() == 0) {
            audioData.setGenre(tag.getFirstGenre());
        }
        if (audioData.getTrack() == null || audioData.getTrack().length() == 0) {
            try {
                audioData.setTrack(tag.getFirstTrack());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private void readV2Tag(AudioMetaData audioData, AbstractID3v2Tag tag) {
        audioData.setTitle(tag.getFirstTitle());
        audioData.setArtist(tag.getFirstArtist());
        audioData.setAlbum(tag.getFirstAlbum());
        audioData.setYear(tag.getFirstYear());
        audioData.setComment(tag.getFirstComment());
        audioData.setGenre(this.parseGenre(tag.getFirstGenre()));
        audioData.setTrack(tag.getFirstTrack());
        audioData.setLicense(tag.getFirst("TCOP"));
        Object privateTag = tag.getFrame("PRIV");
        if (privateTag != null) {
            this.readPrivateTag(privateTag, audioData);
        }
        if (!this.isStoreFile) {
            Object commTag;
            Object userTag;
            Object tencTag = tag.getFrame("TENC");
            if (tencTag instanceof AbstractID3v2Frame) {
                this.readID3V2Frame((AbstractID3v2Frame)tencTag, audioData);
            }
            if ((userTag = tag.getFrame("USER")) instanceof AbstractID3v2Frame) {
                this.readID3V2Frame((AbstractID3v2Frame)userTag, audioData);
            }
            if ((commTag = tag.getFrame("COMM")) instanceof AbstractID3v2Frame) {
                this.readID3V2Frame((AbstractID3v2Frame)commTag, audioData);
            }
        }
        if (this.isStoreFile) {
            if (this.isShareable) {
                audioData.setLicenseType("SHAREABLE");
            } else {
                audioData.setLicenseType("NOT CLEARED");
            }
        }
    }

    private void readPrivateTag(Object frame, AudioMetaData audioData) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>(5);
        if (frame instanceof AbstractID3v2Frame) {
            this.parseTagDataType((AbstractID3v2Frame)frame, map);
        } else if (frame instanceof List) {
            for (Object o : (List)frame) {
                if (!(o instanceof AbstractID3v2Frame)) continue;
                this.parseTagDataType((AbstractID3v2Frame)o, map);
            }
        }
        if (map.containsKey(STORE_OPTIONS_KEY)) {
            this.isStoreFile = true;
            try {
                this.parseStoreOptions(new String((byte[])map.get(STORE_OPTIONS_KEY), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            for (String key : map.keySet()) {
                this.rawContentCheck(audioData, (byte[])map.get(key));
            }
        }
    }

    private void readID3V2Frame(AbstractID3v2Frame frame, AudioMetaData audioData) {
        if (frame == null || frame.getId() == null) {
            return;
        }
        if (frame.getId().equals("APIC")) {
            return;
        }
        if (frame.getBody() != null && frame.getBody().getObject("Text") != null) {
            this.checkMagicString(audioData, frame.getBody().getObject("Text").toString());
        } else {
            this.rawContentCheck(audioData, frame.getRawContent());
        }
    }

    private void parseTagDataType(AbstractID3v2Frame frame, Map<String, byte[]> map) {
        Iterator iterator = frame.getBody().iterator();
        while (iterator.hasNext()) {
            AbstractDataType dataType = (AbstractDataType)iterator.next();
            if (!(dataType.getValue() instanceof String)) continue;
            String key = (String)dataType.getValue();
            if (!iterator.hasNext() || !((dataType = (AbstractDataType)iterator.next()).getValue() instanceof byte[])) continue;
            map.put(key, (byte[])dataType.getValue());
        }
    }

    private void rawContentCheck(AudioMetaData audioDatas, byte[] contentBytes) {
        try {
            String content = new String(contentBytes, "UTF-8");
            this.checkMagicString(audioDatas, content);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void parseStoreOptions(String content) {
        String[] values;
        for (String string : values = content.split(";")) {
            String[] pair = string.split("=");
            if (pair.length != 2 || !pair[0].equals(OVERRIDE_KEY)) continue;
            this.isShareable = Boolean.valueOf(pair[1]);
        }
    }

    private void checkMagicString(AudioMetaData audioData, String content) {
        if (!this.isStoreFile && content.indexOf("NOT CLEARED") != -1) {
            this.isStoreFile = true;
            this.isShareable = false;
        }
    }

    private String parseGenre(String genre) {
        if (genre == null || genre.length() <= 0) {
            return genre;
        }
        String cleanGenre = genre;
        if (genre.charAt(0) == '(') {
            int startIndex = 0;
            for (int i = 0; i < genre.length(); ++i) {
                if (genre.charAt(i) != ')') continue;
                startIndex = i + 1;
            }
            cleanGenre = genre.substring(startIndex);
        }
        return cleanGenre;
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"mp3"};
    }
}

