/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.net.address;

import com.google.inject.Inject;
import java.io.IOException;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.SocketsManager;
import org.limewire.net.TLSManager;
import org.limewire.net.address.AddressConnector;
import org.limewire.nio.observer.ConnectObserver;

@EagerSingleton
public class ConnectableConnector
implements AddressConnector {
    private static final Log LOG = LogFactory.getLog(ConnectableConnector.class, "address-connecting");
    private final SocketsManager socketsManager;
    private final TLSManager tlsManager;

    @Inject
    public ConnectableConnector(SocketsManager socketsManager, TLSManager tlsManager) {
        this.socketsManager = socketsManager;
        this.tlsManager = tlsManager;
        socketsManager.registerConnector(this);
    }

    @Override
    public boolean canConnect(Address address) {
        boolean canConnect = address instanceof Connectable;
        LOG.debugf("{0} connect remote address {1}", (Object)(canConnect ? "can" : "can not"), (Object)address);
        return canConnect;
    }

    @Override
    public void connect(Address address, ConnectObserver observer) {
        Connectable connectable = (Connectable)address;
        try {
            SocketsManager.ConnectType type = connectable.isTLSCapable() && this.tlsManager.isOutgoingTLSEnabled() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
            this.socketsManager.connect(connectable.getInetSocketAddress(), 10000, observer, type);
        }
        catch (IOException e) {
            observer.handleIOException(e);
        }
    }
}

