/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.net.address;

import com.google.inject.Inject;
import com.limegroup.gnutella.NetworkManager;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.io.NetworkUtils;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.RegisteringEventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ConnectivityChangeEvent;
import org.limewire.net.SocketsManager;
import org.limewire.net.address.AddressEvent;
import org.limewire.net.address.AddressResolutionObserver;
import org.limewire.net.address.AddressResolver;
import org.limewire.net.address.FirewalledAddress;

@EagerSingleton
public class SameNATAddressResolver
implements AddressResolver,
RegisteringEventListener<AddressEvent> {
    private static final Log LOG = LogFactory.getLog(SameNATAddressResolver.class, "address-connecting");
    private final NetworkManager networkManager;
    private final EventBroadcaster<ConnectivityChangeEvent> connectivityEventBroadcaster;
    private final AtomicBoolean localAddressEventGuard = new AtomicBoolean(false);

    @Inject
    public SameNATAddressResolver(NetworkManager networkManager, EventBroadcaster<ConnectivityChangeEvent> connectivityEventBroadcaster) {
        this.networkManager = networkManager;
        this.connectivityEventBroadcaster = connectivityEventBroadcaster;
    }

    @Override
    @Inject
    public void register(ListenerSupport<AddressEvent> addressEventListenerSupport) {
        addressEventListenerSupport.addListener(this);
    }

    @Inject
    public void register(SocketsManager socketsManager) {
        socketsManager.registerResolver(this);
    }

    @Override
    public void handleEvent(AddressEvent event) {
        if (this.areLocalAddressesKnown() && this.localAddressEventGuard.compareAndSet(false, true)) {
            this.connectivityEventBroadcaster.broadcast(new ConnectivityChangeEvent());
        }
    }

    @Override
    public boolean canResolve(Address address) {
        if (address instanceof FirewalledAddress) {
            if (this.areLocalAddressesKnown()) {
                return this.isBehindThisNAT((FirewalledAddress)address);
            }
            LOG.debugf("can not resolve remote address {0} because local address is not known", (Object)address);
            return false;
        }
        LOG.debugf("can not resolve remote address {0}", (Object)address);
        return false;
    }

    private boolean areLocalAddressesKnown() {
        return NetworkUtils.isValidAddress(this.networkManager.getExternalAddress()) && NetworkUtils.isValidAddress(this.networkManager.getNonForcedAddress());
    }

    private boolean isBehindThisNAT(FirewalledAddress address) {
        byte[] thisPublicAddress = this.networkManager.getExternalAddress();
        if (!Arrays.equals(address.getPublicAddress().getInetAddress().getAddress(), thisPublicAddress)) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("different public address: local = {0}, remote = {1}", (Object)NetworkUtils.ip2string(thisPublicAddress), (Object)address.getPublicAddress());
            }
            return false;
        }
        byte[] thisPrivateAddress = this.networkManager.getNonForcedAddress();
        if (!NetworkUtils.areInSameSiteLocalNetwork(address.getPrivateAddress().getInetAddress().getAddress(), thisPrivateAddress)) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("different site local networks: local = {0}, remote = {1}", (Object)NetworkUtils.ip2string(thisPrivateAddress), (Object)address.getPrivateAddress());
            }
            return false;
        }
        LOG.debug("addresses behind same NAT!");
        return true;
    }

    @Override
    public <T extends AddressResolutionObserver> T resolve(Address addr, T observer) {
        FirewalledAddress address = (FirewalledAddress)addr;
        assert (this.isBehindThisNAT(address)) : "not behind same NAT: " + address;
        LOG.debugf("resolved remote address {0} to {1}", (Object)address, (Object)address.getPrivateAddress());
        observer.resolved(address.getPrivateAddress());
        return observer;
    }
}

