/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.rudp.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.rudp.messages.LimeAckMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeDataMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeFinMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeKeepAliveMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeSynMessageImpl;
import java.nio.ByteBuffer;
import org.limewire.rudp.messages.AckMessage;
import org.limewire.rudp.messages.DataMessage;
import org.limewire.rudp.messages.FinMessage;
import org.limewire.rudp.messages.KeepAliveMessage;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.RUDPMessageFactory;
import org.limewire.rudp.messages.SynMessage;

@Singleton
class LimeRUDPMessageFactory
implements RUDPMessageFactory {
    private final RUDPMessageFactory delegate;

    @Inject
    public LimeRUDPMessageFactory(@Named(value="delegate") RUDPMessageFactory delegate) {
        if (delegate == null) {
            throw new NullPointerException("Delegate is null");
        }
        if (delegate instanceof LimeRUDPMessageFactory) {
            throw new IllegalArgumentException("Recursive delegation");
        }
        this.delegate = delegate;
    }

    RUDPMessageFactory getDelegate() {
        return this.delegate;
    }

    @Override
    public RUDPMessage createMessage(ByteBuffer ... data) throws MessageFormatException {
        RUDPMessage msg = this.delegate.createMessage(data);
        if (msg instanceof AckMessage) {
            return new LimeAckMessageImpl((AckMessage)msg);
        }
        if (msg instanceof DataMessage) {
            return new LimeDataMessageImpl((DataMessage)msg);
        }
        if (msg instanceof FinMessage) {
            return new LimeFinMessageImpl((FinMessage)msg);
        }
        if (msg instanceof KeepAliveMessage) {
            return new LimeKeepAliveMessageImpl((KeepAliveMessage)msg);
        }
        if (msg instanceof SynMessage) {
            return new LimeSynMessageImpl((SynMessage)msg);
        }
        throw new IllegalArgumentException(msg.getClass() + " is unhandled");
    }

    @Override
    public AckMessage createAckMessage(byte connectionID, long sequenceNumber, long windowStart, int windowSpace) {
        return new LimeAckMessageImpl(this.delegate.createAckMessage(connectionID, sequenceNumber, windowStart, windowSpace));
    }

    @Override
    public DataMessage createDataMessage(byte connectionID, long sequenceNumber, ByteBuffer chunk) {
        return new LimeDataMessageImpl(this.delegate.createDataMessage(connectionID, sequenceNumber, chunk));
    }

    @Override
    public FinMessage createFinMessage(byte connectionID, long sequenceNumber, byte reasonCode) {
        return new LimeFinMessageImpl(this.delegate.createFinMessage(connectionID, sequenceNumber, reasonCode));
    }

    @Override
    public KeepAliveMessage createKeepAliveMessage(byte connectionID, long windowStart, int windowSpace) {
        return new LimeKeepAliveMessageImpl(this.delegate.createKeepAliveMessage(connectionID, windowStart, windowSpace));
    }

    @Override
    public SynMessage createSynMessage(byte connectionID, SynMessage.Role role) {
        return new LimeSynMessageImpl(this.delegate.createSynMessage(connectionID, role));
    }

    @Override
    public SynMessage createSynMessage(byte connectionID, byte theirConnectionID, SynMessage.Role role) {
        return new LimeSynMessageImpl(this.delegate.createSynMessage(connectionID, theirConnectionID, role));
    }
}

