/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.filters.response.ResponseFilter;
import com.limegroup.gnutella.filters.response.ResponseFilterFactory;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.spam.SpamManager;
import com.limegroup.gnutella.util.ClassCNetworks;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.SearchSettings;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.security.SecureMessage;
import org.limewire.util.ByteUtils;

@Singleton
final class SearchResultHandlerImpl
implements SearchResultHandler {
    private static final Log LOG = LogFactory.getLog(SearchResultHandlerImpl.class);
    private static final int QUERY_EXPIRE_TIME = 30000;
    public static final int REPORT_INTERVAL = 15;
    public static final int MAX_RESULTS = 65535;
    private final List<GuidCount> GUID_COUNTS = new Vector<GuidCount>();
    private final Map<GUID, Map<URN, ClassCNetworks[]>> cncCounter = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(10));
    private final NetworkManager networkManager;
    private final Provider<ActivityCallback> activityCallback;
    private final Provider<ConnectionManager> connectionManager;
    private final ConnectionServices connectionServices;
    private final Provider<SpamManager> spamManager;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final NetworkInstanceUtils networkInstanceUtils;
    private volatile ResponseFilter responseFilter;
    private final PushEndpointFactory pushEndpointFactory;
    @InspectionPoint(value="search result handler stats")
    private final Inspectable searchResultHandler = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object inspect() {
            HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
            ret.put("ver", Integer.valueOf(1));
            Map map = SearchResultHandlerImpl.this.cncCounter;
            synchronized (map) {
                for (GUID g : SearchResultHandlerImpl.this.cncCounter.keySet()) {
                    Map m = (Map)SearchResultHandlerImpl.this.cncCounter.get(g);
                    ArrayList toPut = new ArrayList(2);
                    for (ClassCNetworks[] c : m.values()) {
                        HashMap<String, byte[]> cStats = new HashMap<String, byte[]>();
                        cStats.put("ip", c[0].getTopInspectable(10));
                        cStats.put("alt", c[1].getTopInspectable(10));
                        toPut.add(cStats);
                    }
                    ret.put(g.toHexString(), toPut);
                }
            }
            return ret;
        }
    };

    @Inject
    public SearchResultHandlerImpl(NetworkManager networkManager, Provider<ActivityCallback> activityCallback, Provider<ConnectionManager> connectionManager, ConnectionServices connectionServices, Provider<SpamManager> spamManager, RemoteFileDescFactory remoteFileDescFactory, NetworkInstanceUtils networkInstanceUtils, PushEndpointFactory pushEndpointFactory, ResponseFilterFactory responseFilterFactory) {
        this.networkManager = networkManager;
        this.activityCallback = activityCallback;
        this.connectionManager = connectionManager;
        this.connectionServices = connectionServices;
        this.spamManager = spamManager;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.networkInstanceUtils = networkInstanceUtils;
        this.pushEndpointFactory = pushEndpointFactory;
        this.responseFilter = responseFilterFactory.createResponseFilter();
    }

    @Override
    public void setResponseFilter(ResponseFilter responseFilter) {
        this.responseFilter = responseFilter;
    }

    @Override
    public void addQuery(QueryRequest qr) {
        LOG.trace("entered SearchResultHandler.addQuery(QueryRequest)");
        if (!qr.isBrowseHostQuery() && !qr.isWhatIsNewRequest()) {
            this.spamManager.get().startedQuery(qr);
        }
        GuidCount gc = new GuidCount(qr);
        this.GUID_COUNTS.add(gc);
    }

    @Override
    public void removeQuery(GUID guid) {
        LOG.trace("entered SearchResultHandler.removeQuery(GUID)");
        this.cncCounter.remove(guid);
        GuidCount gc = this.removeQueryInternal(guid);
        if (gc != null && !gc.isFinished()) {
            QueryStatusResponse stat = new QueryStatusResponse(guid, 65535);
            this.connectionManager.get().updateQueryStatus(stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueryRequest> getQueriesToReSend() {
        LOG.trace("entered SearchResultHandler.getQueriesToSend()");
        LinkedList<QueryRequest> reSend = null;
        List<GuidCount> list = this.GUID_COUNTS;
        synchronized (list) {
            long now = System.currentTimeMillis();
            for (GuidCount currGC : this.GUID_COUNTS) {
                if (!this.isQueryStillValid(currGC, now)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("adding " + currGC + " to list of queries to resend");
                }
                if (reSend == null) {
                    reSend = new LinkedList<QueryRequest>();
                }
                reSend.add(currGC.getQueryRequest());
            }
        }
        if (reSend == null) {
            return Collections.emptyList();
        }
        return reSend;
    }

    @Override
    public int getNumResultsForQuery(GUID guid) {
        GuidCount gc = this.retrieveGuidCount(guid);
        if (gc != null) {
            return gc.getNumResults();
        }
        return -1;
    }

    @Override
    public void handleQueryReply(QueryReply qr, Address address) {
        try {
            qr.validate();
        }
        catch (BadPacketException bpe) {
            LOG.debug("Ignoring corrupt query reply", bpe);
            return;
        }
        if (!qr.isReplyToMulticastQuery() && !qr.isBrowseHostReply()) {
            if (qr.calculateQualityOfService() < SearchSettings.MINIMUM_SEARCH_QUALITY.getValue()) {
                LOG.debug("Ignoring reply with low quality");
                return;
            }
            if (qr.getSpeed() < SearchSettings.MINIMUM_SEARCH_SPEED.getValue()) {
                LOG.debug("Ignoring reply with low speed");
                return;
            }
            if (qr.isFirewalled()) {
                LOG.debug("The responder is firewalled");
                if (!this.networkInstanceUtils.isVeryCloseIP(qr.getIPBytes())) {
                    byte[] ourAddress;
                    boolean weArePrivate;
                    boolean weAreFirewalled;
                    LOG.debug("...and the responder isn't on a very close IP");
                    boolean bl = weAreFirewalled = !this.networkManager.acceptedIncomingConnection();
                    if (weAreFirewalled) {
                        LOG.debug("...and we're firewalled");
                    }
                    if (weArePrivate = this.networkInstanceUtils.isPrivateAddress(ourAddress = this.networkManager.getAddress())) {
                        LOG.debug("...and we have a private IP");
                    }
                    if (weAreFirewalled || weArePrivate) {
                        boolean theyCanDoFWT;
                        boolean weCanDoFWT = this.networkManager.canDoFWT();
                        if (!weCanDoFWT) {
                            LOG.debug("...and we can't do FWT");
                        }
                        if (!(theyCanDoFWT = qr.getSupportsFWTransfer())) {
                            LOG.debug("...and the responder can't do FWT");
                        }
                        if (!weCanDoFWT || !theyCanDoFWT) {
                            LOG.debug("...so we're ignoring the reply");
                            return;
                        }
                    }
                }
            }
        }
        List<Response> results = null;
        try {
            results = qr.getResultsAsList();
        }
        catch (BadPacketException e) {
            LOG.debug("Error getting results", e);
            return;
        }
        SecureMessage.Status secureStatus = qr.getSecureStatus();
        if (secureStatus == SecureMessage.Status.FAILED) {
            LOG.debug("Ignoring secure result that failed verification");
            return;
        }
        boolean skipSpam = this.isWhatIsNew(qr) || qr.isBrowseHostReply();
        int numGoodSentToFrontEnd = 0;
        float spamThreshold = 1.0f;
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            spamThreshold = SearchSettings.FILTER_SPAM_RESULTS.getValue();
        }
        for (Response response : results) {
            RemoteFileDesc rfd;
            LimeXMLDocument doc;
            if (!this.responseFilter.allow(qr, response)) {
                LOG.debug("Ignoring result because of response filter");
                continue;
            }
            if (secureStatus != SecureMessage.Status.SECURE && response.getUrns().isEmpty()) {
                LOG.debug("Ignoring insecure result with no URNs");
                continue;
            }
            if (secureStatus != SecureMessage.Status.SECURE && ApplicationSettings.USE_SECURE_RESULTS.getValue() && (doc = response.getDocument()) != null && !"".equals(doc.getAction())) {
                LOG.debug("Ignoring insecure result with XML action");
                continue;
            }
            this.countClassC(qr, response);
            try {
                rfd = response.toRemoteFileDesc(qr, address, this.remoteFileDescFactory, this.pushEndpointFactory);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("should not have happened", e);
            }
            rfd.setSecureStatus(secureStatus);
            Set<? extends IpPort> alts = response.getLocations();
            float spamRating = this.spamManager.get().calculateSpamRating(rfd);
            if (skipSpam || spamRating < spamThreshold) {
                ++numGoodSentToFrontEnd;
            }
            this.activityCallback.get().handleQueryResult(rfd, qr, alts);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(numGoodSentToFrontEnd + " responses sent to the UI");
        }
        this.accountAndUpdateDynamicQueriers(qr, numGoodSentToFrontEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countClassC(QueryReply qr, Response r) {
        Map<GUID, Map<URN, ClassCNetworks[]>> map = this.cncCounter;
        synchronized (map) {
            GUID searchGuid = new GUID(qr.getGUID());
            Map<URN, ClassCNetworks[]> m = this.cncCounter.get(searchGuid);
            if (m == null) {
                m = new HashMap<URN, ClassCNetworks[]>();
                this.cncCounter.put(searchGuid, m);
            }
            for (URN u : r.getUrns()) {
                ClassCNetworks[] cnc = m.get(u);
                if (cnc == null) {
                    cnc = new ClassCNetworks[]{new ClassCNetworks(), new ClassCNetworks()};
                    m.put(u, cnc);
                }
                cnc[0].add(ByteUtils.beb2int(qr.getIPBytes(), 0), 1);
                cnc[1].addAll(r.getLocations());
            }
        }
    }

    private void accountAndUpdateDynamicQueriers(QueryReply qr, int numGoodSentToFrontEnd) {
        if (numGoodSentToFrontEnd > 0) {
            GuidCount gc = this.retrieveGuidCount(new GUID(qr.getGUID()));
            if (gc == null) {
                return;
            }
            gc.increment(numGoodSentToFrontEnd);
            if (this.connectionServices.isShieldedLeaf() && !gc.isFinished() && gc.getNumResults() > gc.getNextReportNum()) {
                gc.tallyReport();
                if (gc.getNumResults() > 150) {
                    gc.markAsFinished();
                }
                int numResultsToReport = gc.isFinished() ? 65535 : gc.getNumResults() / 4;
                QueryStatusResponse stat = new QueryStatusResponse(gc.getGUID(), numResultsToReport);
                this.connectionManager.get().updateQueryStatus(stat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount removeQueryInternal(GUID guid) {
        List<GuidCount> list = this.GUID_COUNTS;
        synchronized (list) {
            Iterator<GuidCount> iter = this.GUID_COUNTS.iterator();
            while (iter.hasNext()) {
                GuidCount currGC = iter.next();
                if (!currGC.getGUID().equals(guid)) continue;
                iter.remove();
                return currGC;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount retrieveGuidCount(GUID guid) {
        List<GuidCount> list = this.GUID_COUNTS;
        synchronized (list) {
            for (GuidCount currGC : this.GUID_COUNTS) {
                if (!currGC.getGUID().equals(guid)) continue;
                return currGC;
            }
        }
        return null;
    }

    private boolean isWhatIsNew(QueryReply reply) {
        GuidCount gc = this.retrieveGuidCount(new GUID(reply.getGUID()));
        return gc != null && gc.getQueryRequest().isWhatIsNewRequest();
    }

    private boolean isQueryStillValid(GuidCount gc, long now) {
        LOG.trace("entered SearchResultHandler.isQueryStillValid(GuidCount)");
        return now < gc.getTime() + 30000L && gc.getNumResults() < 150;
    }

    private static class GuidCount {
        private final long _time;
        private final GUID _guid;
        private final QueryRequest _qr;
        private int _numGoodResults;
        private int _nextReportNum = 15;
        private boolean markAsFinished = false;

        public GuidCount(QueryRequest qr) {
            this._qr = qr;
            this._guid = new GUID(qr.getGUID());
            this._time = System.currentTimeMillis();
        }

        public GUID getGUID() {
            return this._guid;
        }

        public int getNumResults() {
            return this._numGoodResults;
        }

        public int getNextReportNum() {
            return this._nextReportNum;
        }

        public long getTime() {
            return this._time;
        }

        public QueryRequest getQueryRequest() {
            return this._qr;
        }

        public boolean isFinished() {
            return this.markAsFinished;
        }

        public void tallyReport() {
            this._nextReportNum = this._numGoodResults + 15;
        }

        public void increment(int good) {
            this._numGoodResults += good;
        }

        public void markAsFinished() {
            this.markAsFinished = true;
        }

        public String toString() {
            return "" + this._guid + ":" + this._numGoodResults + ":" + this._nextReportNum;
        }
    }
}

