/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.Statistics;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.util.Clock;

@EagerSingleton
final class UptimeStatTimer
implements Service {
    @InspectablePrimitive(value="currentUptime", category=DataCategory.USAGE)
    private volatile long currentUptime = 0L;
    private static final int UPDATE_INTERVAL = 10;
    protected static final int HISTORY_LENGTH = 20;
    protected static final int DEFAULT_DOWNTIME = 86400;
    private long lastUpdateTime = 0L;
    private volatile ScheduledFuture<?> future = null;
    private final AtomicBoolean firstUptimeUpdate = new AtomicBoolean(true);
    private final ScheduledExecutorService backgroundExecutor;
    private final Statistics stats;
    private final Clock clock;

    @Inject
    UptimeStatTimer(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Statistics stats, Clock clock) {
        this.backgroundExecutor = backgroundExecutor;
        this.stats = stats;
        this.clock = clock;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Uptime Statistics");
    }

    @Override
    public void initialize() {
        int sessions = ApplicationSettings.SESSIONS.getValue();
        ApplicationSettings.SESSIONS.setValue(sessions + 1);
        long lastShutdown = ApplicationSettings.LAST_SHUTDOWN_TIME.getValue();
        long downtime = lastShutdown == 0L ? 86400L : Math.max(0L, (this.clock.now() - lastShutdown) / 1000L);
        String[] downtimes = ApplicationSettings.DOWNTIME_HISTORY.get();
        String[] uptimes = ApplicationSettings.UPTIME_HISTORY.get();
        downtimes = downtimes.length > uptimes.length ? this.updateHistory(downtimes, Long.toString(downtime)) : this.appendToHistory(downtimes, Long.toString(downtime));
        ApplicationSettings.DOWNTIME_HISTORY.set(downtimes);
        this.lastUpdateTime = this.clock.now();
    }

    @Override
    public void start() {
        this.future = this.backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                UptimeStatTimer.this.refreshStats();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        this.refreshStats();
        ScheduledFuture<?> future = this.future;
        if (future != null) {
            future.cancel(false);
            this.future = null;
        }
    }

    void refreshStats() {
        long now = this.clock.now();
        long elapsed = (now - this.lastUpdateTime) / 1000L;
        if (elapsed > 0L) {
            this.currentUptime += elapsed;
            this.updateUptimeHistory(this.currentUptime);
            long totalUptime = ApplicationSettings.TOTAL_UPTIME.getValue() + elapsed;
            ApplicationSettings.TOTAL_UPTIME.setValue(totalUptime);
            int sessions = ApplicationSettings.SESSIONS.getValue();
            if (sessions > 0) {
                ApplicationSettings.AVERAGE_UPTIME.setValue(totalUptime / (long)sessions);
            }
            ApplicationSettings.FRACTIONAL_UPTIME.setValue(this.stats.calculateFractionalUptime());
            ApplicationSettings.LAST_SHUTDOWN_TIME.setValue(now);
        }
        this.lastUpdateTime = now;
    }

    void updateUptimeHistory(long currentUptime) {
        String[] uptimes = ApplicationSettings.UPTIME_HISTORY.get();
        uptimes = this.firstUptimeUpdate.getAndSet(false) ? this.appendToHistory(uptimes, Long.toString(currentUptime)) : this.updateHistory(uptimes, Long.toString(currentUptime));
        ApplicationSettings.UPTIME_HISTORY.set(uptimes);
    }

    private String[] appendToHistory(String[] original, String newItem) {
        String[] copy;
        if (original.length < 20) {
            copy = new String[original.length + 1];
            System.arraycopy(original, 0, copy, 0, original.length);
        } else {
            copy = new String[20];
            System.arraycopy(original, 1, copy, 0, copy.length - 1);
        }
        copy[copy.length - 1] = newItem;
        return copy;
    }

    private String[] updateHistory(String[] history, String newItem) {
        if (history.length == 0) {
            history = new String[1];
        }
        history[history.length - 1] = newItem;
        return history;
    }
}

