/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Provider;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.http.AltLocHeaderInterceptor;
import com.limegroup.gnutella.http.FWNodeInfoInterceptor;
import com.limegroup.gnutella.http.FeatureHeaderInterceptor;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.http.UserAgentHeaderInterceptor;
import com.limegroup.gnutella.library.CreationTimeCache;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.tigertree.HashTreeWriteHandler;
import com.limegroup.gnutella.tigertree.HashTreeWriteHandlerFactory;
import com.limegroup.gnutella.uploader.FileRequestParser;
import com.limegroup.gnutella.uploader.FileResponseEntityFactory;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.HttpRequestHandlerFactory;
import com.limegroup.gnutella.uploader.THEXResponseEntity;
import com.limegroup.gnutella.uploader.UploadType;
import com.limegroup.gnutella.uploader.authentication.HttpRequestFileViewProvider;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.core.settings.SharingSettings;
import org.limewire.http.BasicHeaderProcessor;
import org.limewire.http.MalformedHeaderException;
import org.limewire.http.RangeHeaderInterceptor;

public class FileRequestHandler
extends SimpleNHttpRequestHandler {
    private static final Log LOG = LogFactory.getLog(FileRequestHandler.class);
    private static final String INACTIVE_RETRY_AFTER = "3600";
    private final HTTPUploadSessionManager sessionManager;
    private final Library library;
    private final HTTPHeaderUtils httpHeaderUtils;
    private final HttpRequestHandlerFactory httpRequestHandlerFactory;
    private final Provider<CreationTimeCache> creationTimeCache;
    private final FileResponseEntityFactory fileResponseEntityFactory;
    private final AltLocManager altLocManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<HashTreeCache> tigerTreeCache;
    private final PushEndpointFactory pushEndpointFactory;
    private final HashTreeWriteHandlerFactory tigerWriteHandlerFactory;
    private final HttpRequestFileViewProvider fileListProvider;

    FileRequestHandler(HTTPUploadSessionManager sessionManager, Library library, HTTPHeaderUtils httpHeaderUtils, HttpRequestHandlerFactory httpRequestHandlerFactory, Provider<CreationTimeCache> creationTimeCache, FileResponseEntityFactory fileResponseEntityFactory, AltLocManager altLocManager, AlternateLocationFactory alternateLocationFactory, Provider<DownloadManager> downloadManager, Provider<HashTreeCache> tigerTreeCache, PushEndpointFactory pushEndpointFactory, HashTreeWriteHandlerFactory tigerWriteHandlerFactory, HttpRequestFileViewProvider fileListProvider) {
        this.sessionManager = sessionManager;
        this.library = library;
        this.httpHeaderUtils = httpHeaderUtils;
        this.httpRequestHandlerFactory = httpRequestHandlerFactory;
        this.creationTimeCache = creationTimeCache;
        this.fileResponseEntityFactory = fileResponseEntityFactory;
        this.altLocManager = altLocManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.downloadManager = downloadManager;
        this.tigerTreeCache = tigerTreeCache;
        this.pushEndpointFactory = pushEndpointFactory;
        this.tigerWriteHandlerFactory = tigerWriteHandlerFactory;
        this.fileListProvider = fileListProvider;
    }

    @Override
    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest request, HttpContext context) throws HttpException, IOException {
        return null;
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling upload request: " + request.getRequestLine().getUri());
        }
        FileRequestParser.FileRequest fileRequest = null;
        HTTPUploader uploader = null;
        try {
            fileRequest = FileRequestParser.parseRequest(this.fileListProvider, request.getRequestLine().getUri(), context);
        }
        catch (IOException e) {
            uploader = this.sessionManager.getOrCreateUploader(request, context, UploadType.MALFORMED_REQUEST, "Malformed Request");
            this.handleMalformedRequest(response, uploader);
        }
        if (fileRequest != null) {
            assert (uploader == null);
            uploader = this.findFileAndProcessHeaders(request, response, context, fileRequest);
        } else if (uploader == null) {
            uploader = this.sessionManager.getOrCreateUploader(request, context, UploadType.FILE_NOT_FOUND, "Unknown Query");
            uploader.setState(Uploader.UploadStatus.FILE_NOT_FOUND);
            response.setStatusCode(404);
        }
        assert (uploader != null);
        this.sessionManager.sendResponse(uploader, response);
    }

    private HTTPUploader findFileAndProcessHeaders(HttpRequest request, HttpResponse response, HttpContext context, FileRequestParser.FileRequest fileRequest) throws IOException, HttpException {
        FileDesc fileDesc = fileRequest.getFileDesc();
        UploadType type = LibraryUtils.isForcedShare(fileDesc) ? UploadType.FORCED_SHARE : UploadType.SHARED_FILE;
        HTTPUploader uploader = this.sessionManager.getOrCreateUploader(request, context, type, fileDesc.getFileName(), fileRequest.getFriendID());
        uploader.setFileDesc(fileDesc);
        BasicHeaderProcessor processor = new BasicHeaderProcessor();
        RangeHeaderInterceptor rangeHeaderInterceptor = new RangeHeaderInterceptor();
        processor.addInterceptor(rangeHeaderInterceptor);
        processor.addInterceptor(new FeatureHeaderInterceptor(uploader));
        processor.addInterceptor(new AltLocHeaderInterceptor(uploader, this.altLocManager, this.alternateLocationFactory));
        processor.addInterceptor(new FWNodeInfoInterceptor(uploader, this.pushEndpointFactory));
        if (!uploader.getFileName().toUpperCase(Locale.US).startsWith("LIMEWIRE")) {
            processor.addInterceptor(new UserAgentHeaderInterceptor(uploader));
        }
        try {
            processor.process(request, context);
        }
        catch (ProblemReadingHeaderException e) {
            this.handleMalformedRequest(response, uploader);
            return uploader;
        }
        catch (MalformedHeaderException e) {
            this.handleMalformedRequest(response, uploader);
            return uploader;
        }
        if (UserAgentHeaderInterceptor.isFreeloader(uploader.getUserAgent())) {
            this.sessionManager.handleFreeLoader(request, response, context, uploader);
            return uploader;
        }
        if (!this.validateHeaders(uploader, fileRequest.isThexRequest())) {
            uploader.setState(Uploader.UploadStatus.FILE_NOT_FOUND);
            response.setStatusCode(404);
            return uploader;
        }
        if (!fileRequest.isThexRequest()) {
            if (rangeHeaderInterceptor.hasRequestedRanges()) {
                RangeHeaderInterceptor.Range[] ranges = rangeHeaderInterceptor.getRequestedRanges();
                if (ranges.length > 1) {
                    this.handleInvalidRange(response, uploader, fileDesc);
                    return uploader;
                }
                uploader.setUploadBegin(ranges[0].getStartOffset(uploader.getFileSize()));
                uploader.setUploadEnd(ranges[0].getEndOffset(uploader.getFileSize()) + 1L);
                uploader.setContainedRangeRequest(true);
            }
            if (!uploader.validateRange()) {
                this.handleInvalidRange(response, uploader, fileDesc);
                return uploader;
            }
        }
        if (fileRequest.isThexRequest()) {
            this.handleTHEXRequest(request, response, context, uploader, fileDesc);
        } else {
            this.handleFileUpload(context, request, response, uploader, fileDesc, fileRequest.getFriendID());
        }
        return uploader;
    }

    private void handleMalformedRequest(HttpResponse response, HTTPUploader uploader) {
        uploader.setState(Uploader.UploadStatus.MALFORMED_REQUEST);
        response.setStatusCode(400);
        response.setReasonPhrase("Malformed Request");
    }

    private void handleFileUpload(HttpContext context, HttpRequest request, HttpResponse response, HTTPUploader uploader, FileDesc fd, String friendId) throws HttpException, IOException {
        if (!uploader.getSession().isAccepted()) {
            HTTPUploadSessionManager.QueueStatus queued = this.sessionManager.enqueue(context, request);
            switch (queued) {
                case REJECTED: {
                    this.httpRequestHandlerFactory.createLimitReachedRequestHandler(uploader).handle(request, response, context);
                    break;
                }
                case BANNED: {
                    uploader.setState(Uploader.UploadStatus.BANNED_GREEDY);
                    response.setStatusCode(403);
                    response.setReasonPhrase("Banned");
                    break;
                }
                case QUEUED: {
                    this.handleQueued(context, request, response, uploader, fd, friendId);
                    break;
                }
                case ACCEPTED: {
                    this.sessionManager.addAcceptedUploader(uploader, context);
                    break;
                }
            }
        }
        if (uploader.getSession().canUpload()) {
            this.handleAccept(context, request, response, uploader, fd, friendId);
        }
    }

    protected void handleAccept(HttpContext context, HttpRequest request, HttpResponse response, HTTPUploader uploader, FileDesc fd, String friendId) throws IOException, HttpException {
        assert (fd != null);
        response.addHeader(HTTPHeaderName.DATE.create(HTTPUtils.getDateValue()));
        response.addHeader(HTTPHeaderName.CONTENT_DISPOSITION.create("attachment; filename=\"" + HTTPUtils.encode(uploader.getFileName(), "US-ASCII") + "\""));
        if (uploader.containedRangeRequest()) {
            String value = "bytes " + uploader.getUploadBegin() + "-" + (uploader.getUploadEnd() - 1L) + "/" + uploader.getFileSize();
            response.addHeader(HTTPHeaderName.CONTENT_RANGE.create(value));
        }
        this.httpHeaderUtils.addAltLocationsHeader(response, uploader.getAltLocTracker(), this.altLocManager);
        this.httpHeaderUtils.addRangeHeader(response, uploader, fd);
        this.httpHeaderUtils.addProxyHeader(response);
        URN urn = fd.getSHA1Urn();
        if (uploader.isFirstReply() && this.creationTimeCache.get().getCreationTime(urn) != null) {
            response.addHeader(HTTPHeaderName.CREATION_TIME.create(this.creationTimeCache.get().getCreationTime(urn).toString()));
        }
        if (uploader.isFirstReply()) {
            this.httpHeaderUtils.addFeatures(response);
        }
        this.addThexUriHeader(response, fd, friendId);
        response.setEntity(this.fileResponseEntityFactory.createFileResponseEntity(uploader, fd.getFile()));
        uploader.setState(Uploader.UploadStatus.UPLOADING);
        if (uploader.isPartial()) {
            response.setStatusCode(206);
        } else {
            response.setStatusCode(200);
        }
    }

    private void addThexUriHeader(HttpResponse response, FileDesc fileDesc, String friendId) {
        if (fileDesc instanceof IncompleteFileDesc) {
            return;
        }
        HashTree tree = this.tigerTreeCache.get().getHashTree(fileDesc);
        if (tree != null) {
            if (friendId != null) {
                try {
                    String uri = "/friend/download/" + URLEncoder.encode(friendId, "UTF-8") + tree.httpStringValue();
                    response.addHeader(HTTPHeaderName.THEX_URI.create(uri));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                response.addHeader(HTTPHeaderName.THEX_URI.create(tree));
            }
        }
    }

    private void handleTHEXRequest(HttpRequest request, HttpResponse response, HttpContext context, HTTPUploader uploader, FileDesc fd) {
        uploader.getSession().updatePollTime(HTTPUploadSessionManager.QueueStatus.BYPASS);
        uploader.setIgnoreTotalAmountUploaded(true);
        HashTree tree = this.tigerTreeCache.get().getHashTree(fd);
        if (tree == null) {
            uploader.setState(Uploader.UploadStatus.FILE_NOT_FOUND);
            response.setStatusCode(404);
            return;
        }
        HashTreeWriteHandler tigerWriteHandler = this.tigerWriteHandlerFactory.createTigerWriteHandler(tree);
        int outputLength = tigerWriteHandler.getOutputLength();
        uploader.setFileSize(outputLength);
        uploader.setUploadBegin(0L);
        uploader.setUploadEnd(outputLength);
        uploader.setState(Uploader.UploadStatus.THEX_REQUEST);
        response.setEntity(new THEXResponseEntity(uploader, tigerWriteHandler, uploader.getFileSize()));
        response.setStatusCode(200);
    }

    private void handleInvalidRange(HttpResponse response, HTTPUploader uploader, FileDesc fd) {
        this.httpHeaderUtils.addAltLocationsHeader(response, uploader.getAltLocTracker(), this.altLocManager);
        this.httpHeaderUtils.addRangeHeader(response, uploader, fd);
        this.httpHeaderUtils.addProxyHeader(response);
        if (fd instanceof IncompleteFileDesc && !this.downloadManager.get().isActivelyDownloading(fd.getSHA1Urn())) {
            response.addHeader(HTTPHeaderName.RETRY_AFTER.create(INACTIVE_RETRY_AFTER));
        }
        uploader.setState(Uploader.UploadStatus.UNAVAILABLE_RANGE);
        response.setStatusCode(416);
        response.setReasonPhrase("Requested Range Unavailable");
    }

    private void handleQueued(HttpContext context, HttpRequest request, HttpResponse response, HTTPUploader uploader, FileDesc fd, String friendId) {
        int position = uploader.getSession().positionInQueue();
        assert (position != -1);
        String value = "position=" + (position + 1) + ", pollMin=" + 45 + ", pollMax=" + 120;
        response.addHeader(HTTPHeaderName.QUEUE.create(value));
        this.httpHeaderUtils.addAltLocationsHeader(response, uploader.getAltLocTracker(), this.altLocManager);
        this.httpHeaderUtils.addRangeHeader(response, uploader, fd);
        if (uploader.isFirstReply()) {
            this.httpHeaderUtils.addFeatures(response);
        }
        this.addThexUriHeader(response, fd, friendId);
        response.setHeader("Connection", "Keep-Alive");
        uploader.setState(Uploader.UploadStatus.QUEUED);
        response.setStatusCode(503);
    }

    private boolean validateHeaders(HTTPUploader uploader, boolean thexRequest) {
        FileDesc fd = uploader.getFileDesc();
        assert (fd != null);
        URN urn = uploader.getRequestedURN();
        if (urn != null && !fd.containsUrn(urn)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid content urn: " + uploader);
            }
            return false;
        }
        if (thexRequest && this.tigerTreeCache.get().getHashTree(fd) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requested thex tree is not available: " + uploader);
            }
            return false;
        }
        if (fd instanceof IncompleteFileDesc) {
            if (!SharingSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sharing of partial files is diabled: " + uploader);
                }
                return false;
            }
            if (thexRequest) {
                return false;
            }
        } else {
            File file = fd.getFile();
            if (file.lastModified() != fd.lastModified()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("File has changed on disk, resharing: " + file);
                }
                this.library.fileChanged(file, fd.getLimeXMLDocuments());
                return false;
            }
        }
        return true;
    }
}

