/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.version.OS;
import com.limegroup.gnutella.version.UpdateInformation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Version;

public class UpdateData
implements Cloneable,
UpdateInformation {
    private static final Log LOG = LogFactory.getLog(UpdateData.class);
    private volatile Version fromVersion;
    private volatile Version toVersion;
    private volatile Version forVersion;
    private volatile boolean isPro;
    private volatile boolean isFree;
    private volatile String updateURL;
    private volatile int updateStyle;
    private volatile Version fromJava;
    private volatile Version toJava;
    private volatile OS[] osList;
    private volatile String language;
    private volatile String updateText;
    private volatile String button1Text;
    private volatile String button2Text;
    private volatile String updateTitle;
    private volatile URN urn;
    private volatile String ttRoot;
    private volatile String updateCommand;
    private volatile String updateFileName;
    private volatile int size;

    UpdateData() {
    }

    public String toString() {
        return "\n{from: " + this.fromVersion + ", to: " + this.toVersion + ", for: " + this.forVersion + ", pro: " + this.isPro + ", free: " + this.isFree + ", url: " + this.updateURL + ", style: " + this.updateStyle + ", javaFrom: " + this.fromJava + ", javaTo: " + this.toJava + ", osList: " + OS.toString(this.osList) + ", language: " + this.language + ", text: " + this.updateText + ", title: " + this.updateTitle + ", urn: " + this.urn + ", ttroot: " + this.ttRoot + ", updateCommand: " + this.updateCommand + ", updateFileName: " + this.updateFileName + ", size: " + this.size + "}";
    }

    void setFromVersion(Version v) {
        this.fromVersion = v;
    }

    void setToVersion(Version v) {
        this.toVersion = v;
    }

    void setForVersion(Version v) {
        this.forVersion = v;
    }

    void setPro(boolean b) {
        this.isPro = b;
    }

    void setFree(boolean b) {
        this.isFree = b;
    }

    void setUpdateURL(String s) {
        this.updateURL = s;
    }

    void setStyle(int s) {
        this.updateStyle = s;
    }

    void setFromJava(Version v) {
        this.fromJava = v;
    }

    void setToJava(Version v) {
        this.toJava = v;
    }

    void setOSList(OS[] os) {
        this.osList = os;
    }

    void setLanguage(String l) {
        this.language = l;
    }

    void setUpdateText(String t) {
        this.updateText = t;
    }

    void setButton1Text(String t) {
        this.button1Text = t;
    }

    void setButton2Text(String t) {
        this.button2Text = t;
    }

    void setUpdateTitle(String t) {
        this.updateTitle = t;
    }

    void setUpdateURN(URN urn) {
        this.urn = urn;
    }

    void setUpdateTTRoot(String root) {
        this.ttRoot = root;
    }

    void setUpdateCommand(String command) {
        this.updateCommand = command;
    }

    void setUpdateFileName(String filename) {
        this.updateFileName = filename;
    }

    void setUpdateSize(int size) {
        this.size = size;
    }

    String getLanguage() {
        return this.language;
    }

    @Override
    public String getUpdateVersion() {
        return this.forVersion.toString();
    }

    @Override
    public String getUpdateText() {
        return this.updateText;
    }

    @Override
    public String getUpdateURL() {
        return this.updateURL;
    }

    @Override
    public int getUpdateStyle() {
        return this.updateStyle;
    }

    @Override
    public String getButton1Text() {
        return this.button1Text;
    }

    @Override
    public String getButton2Text() {
        return this.button2Text;
    }

    @Override
    public String getUpdateTitle() {
        return this.updateTitle;
    }

    @Override
    public String getUpdateFileName() {
        return this.updateFileName;
    }

    @Override
    public String getUpdateCommand() {
        return this.updateCommand;
    }

    @Override
    public URN getUpdateURN() {
        return this.urn;
    }

    @Override
    public String getTTRoot() {
        return this.ttRoot;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    boolean isAllowed(Version currentV, boolean currentPro, int currentStyle, Version currentJava) {
        return currentV.compareTo(this.fromVersion) >= 0 && currentV.compareTo(this.toVersion) < 0 && currentStyle <= this.updateStyle && OS.hasAcceptableOS(this.osList) && this.isValidJava(currentJava) && (currentPro ? this.isPro : this.isFree);
    }

    boolean isValidJava(Version currentV) {
        if (currentV == null || this.fromJava == null && this.toJava == null) {
            return true;
        }
        if (this.fromJava == null) {
            return currentV.compareTo(this.toJava) < 0;
        }
        if (this.toJava == null) {
            return currentV.compareTo(this.fromJava) >= 0;
        }
        return currentV.compareTo(this.fromJava) >= 0 && currentV.compareTo(this.toJava) < 0;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            LOG.error("shoulda cloned", cnse);
        }
        return clone;
    }
}

