/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.xml.GenericXmlDocument;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.XMLParsingUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Singleton
class LimeXMLDocumentFactoryImpl
implements LimeXMLDocumentFactory {
    private static final Log LOG = LogFactory.getLog(LimeXMLDocumentFactoryImpl.class);
    private static final String XML_ID_ATTRIBUTE = "identifier__";
    private static final String XML_ACTION_ATTRIBUTE = "action__";
    static final String XML_INDEX_ATTRIBUTE = "index__";
    private static final String XML_VERSION_ATTRIBUTE = "internal_version__";
    private final Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository;

    @Inject
    public LimeXMLDocumentFactoryImpl(Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository) {
        this.limeXMLSchemaRepository = limeXMLSchemaRepository;
    }

    @Override
    public LimeXMLDocument createLimeXMLDocument(String xml) throws SAXException, SchemaNotFoundException, IOException {
        if (xml == null || xml.equals("")) {
            throw new SAXException("null or empty string");
        }
        InputSource doc = new InputSource(new StringReader(xml));
        XMLParsingUtils.ParseResult result = XMLParsingUtils.parse(doc);
        if (result.isEmpty()) {
            throw new IOException("No element present");
        }
        if (result.schemaURI == null) {
            throw new SchemaNotFoundException("no schema");
        }
        Map map = (Map)result.get(0);
        DocInfo docInfo = this.setFields(result.canonicalKeyPrefix, map);
        LimeXMLSchema schema = this.limeXMLSchemaRepository.get().getSchema(result.schemaURI);
        return this.createDocument(schema, map, docInfo);
    }

    @Override
    public LimeXMLDocument createLimeXMLDocument(Map<String, String> map, String schemaUri, String keyPrefix) throws IOException {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("empty map");
        }
        if (schemaUri == null) {
            throw new IOException("null schemaUri");
        }
        map.remove(keyPrefix + XML_ID_ATTRIBUTE);
        DocInfo docInfo = this.setFields(keyPrefix, map);
        LimeXMLSchema schema = this.limeXMLSchemaRepository.get().getSchema(schemaUri);
        return this.createDocument(schema, map, docInfo);
    }

    @Override
    public LimeXMLDocument createLimeXMLDocument(Collection<? extends Map.Entry<String, String>> nameValueList, String schemaURI) {
        if (nameValueList.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        if (schemaURI == null) {
            throw new IllegalArgumentException("null schemaUri not allowed");
        }
        HashMap<String, String> map = new HashMap<String, String>(nameValueList.size());
        for (Map.Entry<String, String> entry : nameValueList) {
            String value;
            String key = entry.getKey() == null ? null : entry.getKey().trim().intern();
            String string = value = entry.getValue() == null ? null : entry.getValue().trim().intern();
            if (StringUtils.isEmpty(key) || value == null) continue;
            map.put(key, value);
        }
        DocInfo docInfo = this.scanFields(map);
        if (docInfo == null) {
            throw new IllegalArgumentException("invalid nameValueList: " + nameValueList);
        }
        LimeXMLSchema limeXMLSchema = this.limeXMLSchemaRepository.get().getSchema(schemaURI);
        try {
            return this.createDocument(limeXMLSchema, map, docInfo);
        }
        catch (IOException iox) {
            throw new IllegalArgumentException(iox);
        }
    }

    private LimeXMLDocument createDocument(LimeXMLSchema schema, Map<String, String> map, DocInfo docInfo) throws IOException {
        if (!this.isValid(schema, map)) {
            throw new IOException("invalid doc! " + map + " \nschema: " + (schema != null ? schema.getSchemaURI() : "null schema"));
        }
        return new GenericXmlDocument(schema, map, docInfo.version, docInfo.action, docInfo.licenseType);
    }

    private boolean isValid(LimeXMLSchema schema, Map<String, String> map) {
        if (schema == null) {
            return false;
        }
        List<String> fNames = schema.getCanonicalizedFieldNames();
        for (String fieldName : fNames) {
            if (map.get(fieldName) == null) continue;
            return true;
        }
        return false;
    }

    private DocInfo setFields(String prefix, Map<String, String> inputMap) {
        DocInfo docInfo = new DocInfo();
        docInfo.action = inputMap.get(prefix + XML_ACTION_ATTRIBUTE);
        String license = inputMap.get(prefix + "license__");
        String type = inputMap.get(prefix + "licensetype__");
        if (LOG.isDebugEnabled()) {
            LOG.debug("type: " + type);
        }
        docInfo.licenseType = LicenseType.determineLicenseType(license, type);
        if (docInfo.licenseType == LicenseType.CC_LICENSE) {
            inputMap.put(prefix + "licensetype__", "creativecommons.org/licenses/");
        } else if (docInfo.licenseType == LicenseType.LIMEWIRE_STORE_PURCHASE) {
            inputMap.put(prefix + "licensetype__", LicenseType.LIMEWIRE_STORE_PURCHASE.toString());
        } else if (docInfo.licenseType == LicenseType.LIMEWIRE_STORE_RESHAREABLE) {
            inputMap.put(prefix + "licensetype__", LicenseType.LIMEWIRE_STORE_RESHAREABLE.toString());
        }
        String versionString = inputMap.get(prefix + XML_VERSION_ATTRIBUTE);
        if (versionString != null) {
            try {
                docInfo.version = Integer.parseInt(versionString);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set version to: " + docInfo.version);
                }
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Unable to set version", nfe);
                docInfo.version = 3;
            }
        } else {
            docInfo.version = 3;
        }
        inputMap.remove(prefix + XML_VERSION_ATTRIBUTE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fields after setting: " + inputMap);
        }
        return docInfo;
    }

    private DocInfo scanFields(Map<String, String> inputMap) {
        String canonicalKey = this.getCanonicalKey(inputMap.entrySet());
        if (canonicalKey == null) {
            return null;
        }
        DocInfo docInfo = this.setFields(canonicalKey, inputMap);
        inputMap.remove(canonicalKey + XML_INDEX_ATTRIBUTE);
        inputMap.remove(canonicalKey + XML_ID_ATTRIBUTE);
        return docInfo;
    }

    private String getCanonicalKey(Collection<? extends Map.Entry<String, String>> entries) {
        if (entries.isEmpty()) {
            return null;
        }
        Map.Entry<String, String> firstEntry = entries.iterator().next();
        String firstKey = firstEntry.getKey();
        int idx = firstKey.indexOf("__");
        if ((idx = firstKey.indexOf("__", idx + 1)) == -1) {
            return null;
        }
        return firstKey.substring(0, idx + 2);
    }

    private static class DocInfo {
        private LicenseType licenseType;
        private int version;
        private String action;

        private DocInfo() {
        }
    }
}

