/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.chunks.AbstractChunk;
import de.kapsi.net.daap.chunks.ShortChunk;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UShortChunk
extends AbstractChunk
implements ShortChunk {
    private static final Log LOG = LogFactory.getLog(UShortChunk.class);
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 65535;
    protected int value = 0;

    public UShortChunk(int type, String name, int value) {
        super(type, name);
        this.setValue(value);
    }

    public UShortChunk(String type, String name, int value) {
        super(type, name);
        this.setValue(value);
    }

    public void setValue(int value) {
        this.value = UShortChunk.checkUShortRange(value);
    }

    public int getValue() {
        return this.value;
    }

    public static int checkUShortRange(int value) throws IllegalArgumentException {
        if ((value < 0 || value > 65535) && LOG.isErrorEnabled()) {
            LOG.error("Value is outside of unsigned short range: " + value);
        }
        return value;
    }

    public int getType() {
        return 3;
    }

    public String toString(int indent) {
        return UShortChunk.indent(indent) + this.name + "(" + this.getContentCodeString() + "; ushort)=" + this.getValue();
    }
}

