/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import java.io.Serializable;
import java.util.regex.Pattern;

public class MimeType
implements Comparable,
Serializable {
    private static final long serialVersionUID = -1324243127744494894L;
    private static final Pattern mimeSplitter = Pattern.compile("[/;]++");
    private String mediaType = "*";
    private String subType = "*";
    private int specificity = 1;

    public MimeType(MimeType mimeType) {
        this.mediaType = mimeType.mediaType;
        this.subType = mimeType.subType;
        this.specificity = mimeType.specificity;
    }

    public MimeType(String string) throws MimeException {
        if (string == null || string.trim().length() == 0) {
            throw new MimeException("Invalid MimeType [" + string + "]");
        }
        String[] stringArray = mimeSplitter.split(string.trim());
        if (stringArray.length > 0) {
            this.mediaType = this.getValidMediaType(stringArray[0]);
        }
        if (stringArray.length > 1) {
            this.subType = this.getValidSubType(stringArray[1]);
        }
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getSubType() {
        return this.subType;
    }

    private boolean match(String string) {
        return this.toString().equals(string);
    }

    public int hashCode() {
        return 31 * this.mediaType.hashCode() + this.subType.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof MimeType) {
            if (this.mediaType.equals(((MimeType)object).mediaType) && this.subType.equals(((MimeType)object).subType)) {
                return true;
            }
        } else if (object instanceof String) {
            return this.match((String)object);
        }
        return false;
    }

    public String toString() {
        return this.mediaType + "/" + this.subType;
    }

    public int getSpecificity() {
        return this.specificity;
    }

    void setSpecificity(int n) {
        this.specificity = n;
    }

    private String getValidMediaType(String string) {
        if (string == null || string.trim().length() == 0) {
            return "*";
        }
        return string;
    }

    private String getValidSubType(String string) {
        if (string == null || string.trim().length() == 0 || "*".equals(this.mediaType)) {
            return "*";
        }
        return string;
    }

    public int compareTo(Object object) {
        if (object instanceof MimeType) {
            return this.toString().compareTo(((MimeType)object).toString());
        }
        return 0;
    }
}

