/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio;

public class Utils {
    public static short[] byteToShortArray(byte[] byteArray, int offset, int length, boolean little) throws ArrayIndexOutOfBoundsException {
        if (0 < length && offset + length <= byteArray.length) {
            int shortLength = length / 2;
            short[] shortArray = new short[shortLength];
            int i = offset;
            for (int j = 0; j < shortLength; ++j) {
                int temp;
                if (little) {
                    temp = byteArray[i++] & 0xFF;
                    temp |= 0xFF00 & byteArray[i++] << 8;
                } else {
                    temp = byteArray[i++] << 8;
                    temp |= 0xFF & byteArray[i++];
                }
                shortArray[j] = (short)temp;
                temp = 0;
            }
            return shortArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", array length: " + byteArray.length);
    }

    public static void shortArrToByteArr(short[] in, byte[] res, boolean little) {
        int resIx = 0;
        byte[] tmp = null;
        for (int i = 0; i < in.length; ++i) {
            tmp = Utils.shortToBytes(in[i], little);
            res[resIx++] = tmp[0];
            res[resIx++] = tmp[1];
        }
    }

    public static byte[] shortToBytes(short v, boolean little) {
        byte[] rtn = new byte[2];
        if (little) {
            rtn[0] = (byte)(v & 0xFF);
            rtn[1] = (byte)(v >>> 8 & 0xFF);
        } else {
            rtn[0] = (byte)(v >>> 8 & 0xFF);
            rtn[1] = (byte)(v & 0xFF);
        }
        return rtn;
    }
}

