/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.util.EventListener;
import javax.media.Control;
import javax.media.Controller;
import javax.media.NotRealizedError;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

public abstract class AbstractListenerControl
implements Control {
    private EventListener currListener;
    private EventListener defaultListener;
    private Controller controller;
    private Component component;
    protected final Skin skin;
    private boolean isOperational = true;

    protected AbstractListenerControl(Skin skin) {
        this.skin = skin;
        this.component = this.createControlComponent(skin);
        this.initListener(this.createControlListener());
    }

    protected AbstractListenerControl(Skin skin, Controller controller) {
        this(skin);
        this.setController(controller);
    }

    public void setController(Controller controller) {
        if (this.controller != null) {
            throw new IllegalArgumentException("Controller already set on Control");
        }
        if (controller.getState() < 300) {
            throw new NotRealizedError("Control requires realized Controller");
        }
        this.controller = controller;
        this.setControllerHook(controller);
    }

    protected void setControllerHook(Controller controller) {
    }

    protected void initListener(EventListener listener) {
        this.currListener = this.defaultListener = listener;
        this.addControlListener(this.defaultListener);
    }

    public Component getControlComponent() {
        return this.component;
    }

    protected void setControlListener(EventListener listener) {
        if (this.currListener != null) {
            this.removeControlListener(this.currListener);
        }
        this.addControlListener(listener);
        this.currListener = listener;
    }

    protected void setComponent(Component component) {
        this.setComponentAndListener(component, this.getDefaultControlListener());
    }

    protected void setComponentAndListener(Component component, EventListener listener) {
        this.component = component;
        this.setControlListener(listener);
    }

    protected EventListener getDefaultControlListener() {
        return this.defaultListener;
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected abstract EventListener createControlListener();

    protected abstract Component createControlComponent(Skin var1);

    protected abstract void addControlListener(EventListener var1);

    protected abstract void removeControlListener(EventListener var1);

    protected void setOperational(boolean flag) {
        this.isOperational = flag;
    }

    public boolean isOperational() {
        return this.isOperational;
    }

    public Controller getController() {
        return this.controller;
    }
}

