/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import net.sf.fmj.filtergraph.FilterGraph;
import net.sf.fmj.filtergraph.Link;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.filtergraph.model.FilterGraphModel;
import net.sf.fmj.filtergraph.model.LinkModel;
import net.sf.fmj.filtergraph.model.NodeModel;

public final class FilterGraphModelTranslator {
    private FilterGraphModelTranslator() {
    }

    public static FilterGraphModel toModel(FilterGraph g) {
        return new FilterGraphModel(FilterGraphModelTranslator.toModel(g.getRoot()));
    }

    private static NodeModel toModel(Node n) {
        if (n == null) {
            return null;
        }
        NodeModel result = new NodeModel(n.getPlugInType(), n.getPlugIn().getClass().getName());
        for (int i = 0; i < n.getNumDestLinks(); ++i) {
            Link link = n.getDestLink(i);
            result.addDestLink(FilterGraphModelTranslator.toModel(link));
        }
        return result;
    }

    private static LinkModel toModel(Link link) {
        return new LinkModel(link.getSourcePin().getTrack(), link.getDestPin().getTrack(), link.getDestPin().getFormat(), FilterGraphModelTranslator.toModel(link.getDestNode()));
    }
}

