/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import com.lti.utils.ObjUtils;
import java.util.Comparator;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.utility.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FormatProximityComparator
implements Comparator<Format> {
    private final Format target;
    private static final int EQUALS = Integer.MIN_VALUE;
    private static final int MATCHES = 0x40000000;
    private static final int SAME_CLASS = 0x20000000;
    private static final int ASSIGNABLE = 0x10000000;
    private static final int ENCODINGS_EQUAL = 0x8000000;
    private static final int DATA_TYPES_EQUAL = 0x4000000;
    private static int SAMPLE_RATE_EQUAL = 524288;
    private static int SAMPLE_RATE_MATCHES = 262144;
    private static int SAMPLE_SIZE_IN_BITS_EQUAL = 524288;
    private static int SAMPLE_SIZE_IN_BITS_MATCHES = 262144;
    private static int CHANNELS_EQUAL = 524288;
    private static int CHANNELS_MATCHES = 262144;
    private static int ENDIAN_EQUAL = 524288;
    private static int ENDIAN_MATCHES = 262144;
    private static int SIGNED_EQUAL = 524288;
    private static int SIGNED_MATCHES = 262144;
    private static int FRAME_SIZE_IN_BITS_EQUAL = 524288;
    private static int FRAME_SIZE_IN_BITS_MATCHES = 262144;
    private static int FRAME_RATE_EQUAL = 524288;
    private static int FRAME_RATE_MATCHES = 262144;

    public FormatProximityComparator(Format target) {
        this.target = target;
    }

    @Override
    public int compare(Format a, Format b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return -1 * (FormatProximityComparator.similarity(a, this.target) - FormatProximityComparator.similarity(b, this.target));
    }

    private static int similarity(Format a, Format b) {
        if (a.equals(b)) {
            return Integer.MIN_VALUE;
        }
        int n = 0;
        if (a.matches(b)) {
            n += 0x40000000;
        }
        if (a.getClass() == b.getClass()) {
            n += 0x20000000;
        }
        if (a.getClass().isAssignableFrom(b.getClass()) || b.getClass().isAssignableFrom(a.getClass())) {
            n += 0x10000000;
        }
        if (ObjUtils.equal(a.getEncoding(), b.getEncoding())) {
            n += 0x8000000;
        }
        if (ObjUtils.equal(a.getDataType(), b.getDataType())) {
            n += 0x4000000;
        }
        if (a instanceof AudioFormat && b instanceof AudioFormat) {
            n += FormatProximityComparator.audioFormatSimilarity((AudioFormat)a, (AudioFormat)b);
        }
        return n;
    }

    private static int similarity(int a, int b, int equalsValue, int matchesValue) {
        int n = 0;
        if (a == b) {
            n += equalsValue;
        }
        if (FormatUtils.matches(a, b)) {
            n += matchesValue;
        }
        return n;
    }

    private static int similarity(float a, float b, int equalsValue, int matchesValue) {
        int n = 0;
        if (a == b) {
            n += equalsValue;
        }
        if (FormatUtils.matches(a, b)) {
            n += matchesValue;
        }
        return n;
    }

    private static int similarity(double a, double b, int equalsValue, int matchesValue) {
        int n = 0;
        if (a == b) {
            n += equalsValue;
        }
        if (FormatUtils.matches(a, b)) {
            n += matchesValue;
        }
        return n;
    }

    private static int audioFormatSimilarity(AudioFormat a, AudioFormat b) {
        int n = 0;
        n += FormatProximityComparator.similarity(a.getSampleRate(), b.getSampleRate(), SAMPLE_RATE_EQUAL, SAMPLE_RATE_MATCHES);
        n += FormatProximityComparator.similarity(a.getSampleSizeInBits(), b.getSampleSizeInBits(), SAMPLE_SIZE_IN_BITS_EQUAL, SAMPLE_SIZE_IN_BITS_MATCHES);
        n += FormatProximityComparator.similarity(a.getChannels(), b.getChannels(), CHANNELS_EQUAL, CHANNELS_MATCHES);
        n += FormatProximityComparator.similarity(a.getEndian(), b.getEndian(), ENDIAN_EQUAL, ENDIAN_MATCHES);
        n += FormatProximityComparator.similarity(a.getSigned(), b.getSigned(), SIGNED_EQUAL, SIGNED_MATCHES);
        n += FormatProximityComparator.similarity(a.getFrameSizeInBits(), b.getFrameSizeInBits(), FRAME_SIZE_IN_BITS_EQUAL, FRAME_SIZE_IN_BITS_MATCHES);
        return n += FormatProximityComparator.similarity(a.getFrameRate(), b.getFrameRate(), FRAME_RATE_EQUAL, FRAME_RATE_MATCHES);
    }
}

