/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.media.Buffer;

public class InputStreamReader
extends InputStream {
    private final InputStream is;
    private final int bufferSize;
    private ReaderThread readerThread;
    private final ProducerConsumerQueue emptyQueue = new ProducerConsumerQueue();
    private final ProducerConsumerQueue fullQueue = new ProducerConsumerQueue();
    private boolean readerThreadStarted;
    private Buffer readBuffer;
    private IOException readException;

    public InputStreamReader(InputStream is, int bufferSize) {
        this.is = is;
        this.bufferSize = bufferSize;
        for (int i = 0; i < 2; ++i) {
            Buffer b = new Buffer();
            b.setData(new byte[bufferSize]);
            try {
                this.emptyQueue.put(b);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.readerThread = new ReaderThread(this.emptyQueue, this.fullQueue, is, bufferSize);
        this.readerThread.setName("ReaderThread for " + is);
        this.readerThread.setDaemon(true);
    }

    public void startReaderThread() {
        if (!this.readerThreadStarted) {
            this.readerThread.start();
            this.readerThreadStarted = true;
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.readerThread != null) {
            this.readerThread.close();
            this.readerThread = null;
        }
    }

    public int available() throws IOException {
        if (this.readException != null) {
            throw this.readException;
        }
        if (this.readBuffer != null && this.readBuffer.getLength() > 0) {
            return this.readBuffer.getLength();
        }
        return 0;
    }

    public int read() throws IOException {
        byte[] ba = new byte[1];
        int result = this.read(ba, 0, 1);
        if (result == -1) {
            return -1;
        }
        return ba[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            if (this.readBuffer == null && this.readException == null) {
                Object o = this.fullQueue.get();
                if (o instanceof IOException) {
                    this.readException = (IOException)o;
                } else {
                    this.readBuffer = (Buffer)o;
                }
            }
            if (this.readException != null) {
                throw this.readException;
            }
            if (this.readBuffer.isEOM()) {
                return -1;
            }
            byte[] readBufferData = (byte[])this.readBuffer.getData();
            int lenToCopy = this.readBuffer.getLength() < len ? this.readBuffer.getLength() : len;
            System.arraycopy(readBufferData, this.readBuffer.getOffset(), b, off, lenToCopy);
            this.readBuffer.setOffset(this.readBuffer.getOffset() + lenToCopy);
            this.readBuffer.setLength(this.readBuffer.getLength() - lenToCopy);
            if (this.readBuffer.getLength() == 0) {
                this.emptyQueue.put(this.readBuffer);
                this.readBuffer = null;
            }
            return lenToCopy;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    private static class ReaderThread
    extends CloseableThread {
        private final ProducerConsumerQueue emptyQueue;
        private final ProducerConsumerQueue fullQueue;
        private final InputStream is;
        private final int bufferSize;

        public ReaderThread(ProducerConsumerQueue emptyQueue, ProducerConsumerQueue fullQueue, InputStream is, int bufferSize) {
            this.emptyQueue = emptyQueue;
            this.fullQueue = fullQueue;
            this.is = is;
            this.bufferSize = bufferSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isClosing()) {
                    Buffer b = (Buffer)this.emptyQueue.get();
                    b.setEOM(false);
                    b.setLength(0);
                    b.setOffset(0);
                    int len = this.is.read((byte[])b.getData(), 0, this.bufferSize);
                    if (len < 0) {
                        b.setEOM(true);
                    } else {
                        b.setLength(len);
                    }
                    this.fullQueue.put(b);
                }
            }
            catch (InterruptedException e) {
            }
            catch (IOException e) {
                try {
                    this.fullQueue.put(e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.setClosed();
            }
        }
    }
}

