/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.civil;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.Image;
import com.lti.civil.VideoFormat;
import com.lti.utils.synchronization.SynchronizedBoolean;
import com.lti.utils.synchronization.SynchronizedObjectHolder;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Control;
import javax.media.Format;
import javax.media.Owned;
import javax.media.Time;
import javax.media.cdm.CaptureDeviceManager;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.control.FrameRateControl;
import javax.media.format.RGBFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.RingBuffer;

public class DataSource
extends PushBufferDataSource
implements CaptureDevice,
FrameGrabbingControl {
    private static final boolean TRACE = true;
    private static final Logger logger = LoggerSingleton.logger;
    private CaptureSystem system;
    private String deviceId;
    private CaptureStream captureStream;
    private MyPushBufferStream pushBufferStream;
    private RingBuffer jitterBuffer;
    private int jitterbuflen = 1;
    protected Object[] controls = new Object[]{new CivilFormatControl(), new JitterBufferControl(), new VideoFrameRateControl()};
    private String deviceName = "";
    private javax.media.format.VideoFormat outputVideoFormat;
    private float frameRate = -1.0f;
    private int framesProcessed;
    private long lastTimestamp;
    private boolean connected;
    private Buffer currentBuffer;
    private Object currentBufferMutex = new Object();
    private static final String CONTENT_TYPE = "raw";
    private final SynchronizedBoolean started = new SynchronizedBoolean(false);
    private final SynchronizedObjectHolder transferHandlerHolder = new SynchronizedObjectHolder();
    private boolean enabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer grabFrame() {
        Buffer aBuffer = null;
        Object object = this.currentBufferMutex;
        synchronized (object) {
            if (null != this.currentBuffer) {
                aBuffer = (Buffer)this.currentBuffer.clone();
                aBuffer.setFormat((Format)this.currentBuffer.getFormat().clone());
            }
        }
        return aBuffer;
    }

    public Component getControlComponent() {
        return null;
    }

    public void connect() throws IOException {
        logger.fine("civil: connect");
        if (this.connected) {
            return;
        }
        if (null == this.jitterBuffer) {
            this.jitterBuffer = new RingBuffer(this.jitterbuflen);
            logger.fine("jitterbuflen=" + this.jitterbuflen);
        }
        try {
            CaptureSystemFactory factory = DefaultCaptureSystemFactorySingleton.instance();
            this.system = factory.createCaptureSystem();
            this.system.init();
            logger.fine("Opening " + this.getLocator().getRemainder());
            int ordinal = DataSource.ordinal(this.getLocator().getRemainder());
            if (ordinal >= 0) {
                this.deviceId = this.deviceIdFromOrdinal(ordinal);
                if (this.deviceId == null) {
                    throw new IOException("Unable to convert ordinal " + ordinal + " to a capture device");
                }
            } else {
                this.deviceId = this.getLocator().getRemainder();
            }
            CaptureDeviceInfo cdi = null;
            Vector deviceList = (Vector)CaptureDeviceManager.getDeviceList(null).clone();
            for (int i = 0; i < deviceList.size() && !(cdi = (CaptureDeviceInfo)deviceList.elementAt(i)).getLocator().getRemainder().equalsIgnoreCase(this.deviceId); ++i) {
            }
            this.deviceName = "";
            if (null != cdi) {
                this.deviceName = cdi.getName();
            }
            this.captureStream = this.system.openCaptureDeviceStream(this.deviceId);
            this.outputVideoFormat = DataSource.convertCivilFormat(this.captureStream.getVideoFormat());
            this.captureStream.setObserver((CaptureObserver)new MyCaptureObserver());
            this.pushBufferStream = new MyPushBufferStream();
        }
        catch (CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            throw new IOException("" + (Object)((Object)e));
        }
        this.connected = true;
    }

    private static int ordinal(String remainder) {
        try {
            if (remainder.startsWith("/")) {
                remainder = remainder.substring(1);
            }
            return Integer.parseInt(remainder);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String deviceIdFromOrdinal(int index) throws CaptureException {
        List list = this.system.getCaptureDeviceInfoList();
        if (index < 0 || index >= list.size()) {
            return null;
        }
        com.lti.civil.CaptureDeviceInfo info = (com.lti.civil.CaptureDeviceInfo)list.get(index);
        return info.getDeviceID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        logger.fine("civil: disconnect");
        if (!this.connected) {
            return;
        }
        try {
            this.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
        Object e = this.currentBufferMutex;
        synchronized (e) {
            this.currentBuffer = null;
        }
        if (this.captureStream != null) {
            try {
                this.captureStream.dispose();
            }
            catch (CaptureException e2) {
                logger.log(Level.WARNING, "" + (Object)((Object)e2), e2);
            }
            finally {
                this.captureStream = null;
            }
        }
        try {
            this.system.dispose();
        }
        catch (Exception e3) {
            logger.log(Level.WARNING, "" + e3, e3);
        }
        this.system = null;
        this.connected = false;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getControl(String controlType) {
        Class<?> c;
        try {
            c = Class.forName(controlType);
        }
        catch (Exception e) {
            return null;
        }
        Object[] controls = this.getControls();
        if (controls == null) {
            return null;
        }
        for (Object o : controls) {
            Control control = (Control)o;
            if (!c.isInstance(control)) continue;
            return control;
        }
        return null;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public void start() throws IOException {
        logger.fine("civil: start");
        if (this.started.getValue()) {
            logger.warning("Civil DataSource.start called while already started, ignoring");
            return;
        }
        try {
            this.captureStream.start();
        }
        catch (CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            throw new IOException("" + (Object)((Object)e));
        }
        this.started.setValue(true);
    }

    public void stop() throws IOException {
        logger.fine("civil: stop");
        if (!this.started.getValue()) {
            return;
        }
        try {
            if (this.captureStream != null) {
                this.captureStream.stop();
            }
        }
        catch (CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            throw new IOException("" + (Object)((Object)e));
        }
        finally {
            this.started.setValue(false);
        }
    }

    public Time getDuration() {
        return DURATION_UNBOUNDED;
    }

    public PushBufferStream[] getStreams() {
        logger.fine("getStreams");
        if (this.pushBufferStream == null) {
            return new PushBufferStream[0];
        }
        return new PushBufferStream[]{this.pushBufferStream};
    }

    public static javax.media.format.VideoFormat convertCivilFormat(VideoFormat civilVideoFormat) {
        int bitsPerPixel;
        if (civilVideoFormat.getFormatType() == 1) {
            bitsPerPixel = 24;
        } else if (civilVideoFormat.getFormatType() == 2) {
            bitsPerPixel = 32;
        } else {
            throw new IllegalArgumentException();
        }
        int red = 3;
        int green = 2;
        int blue = 1;
        float fps = civilVideoFormat.getFPS();
        float frameRate = fps < 0.0f ? -1.0f : fps;
        return new RGBFormat(new Dimension(civilVideoFormat.getWidth(), civilVideoFormat.getHeight()), -1, byte[].class, frameRate, bitsPerPixel, red, green, blue);
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return new CaptureDeviceInfo(this.deviceName, this.getLocator(), this.getFormatControls()[0].getSupportedFormats());
    }

    public FormatControl[] getFormatControls() {
        return new FormatControl[]{new CivilFormatControl()};
    }

    private class JitterBufferControl
    implements BufferControl,
    Owned {
        private JitterBufferControl() {
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public long getBufferLength() {
            return DataSource.this.jitterbuflen;
        }

        public long setBufferLength(long time) {
            boolean isStarted = false;
            if (DataSource.this.started.getValue()) {
                isStarted = true;
                try {
                    DataSource.this.stop();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
            DataSource.this.jitterbuflen = (int)time;
            DataSource.this.jitterBuffer = new RingBuffer(DataSource.this.jitterbuflen);
            logger.fine("jitterbuflen=" + DataSource.this.jitterbuflen);
            if (isStarted) {
                try {
                    DataSource.this.start();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
            return DataSource.this.jitterbuflen;
        }

        public long getMinimumThreshold() {
            return -1L;
        }

        public long setMinimumThreshold(long time) {
            return -1L;
        }

        public void setEnabledThreshold(boolean b) {
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public Component getControlComponent() {
            return null;
        }
    }

    private class VideoFrameRateControl
    implements FrameRateControl,
    Owned {
        private VideoFrameRateControl() {
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public float getFrameRate() {
            return DataSource.this.frameRate;
        }

        public float setFrameRate(float newFrameRate) {
            try {
                return newFrameRate;
            }
            catch (Exception exception) {
                return -1.0f;
            }
        }

        public float getMaxSupportedFrameRate() {
            return -1.0f;
        }

        public float getPreferredFrameRate() {
            return -1.0f;
        }

        public Component getControlComponent() {
            return null;
        }
    }

    private class CivilFormatControl
    implements FormatControl,
    Owned {
        private CivilFormatControl() {
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public Component getControlComponent() {
            return null;
        }

        public Format getFormat() {
            try {
                VideoFormat vf = DataSource.this.captureStream.getVideoFormat();
                return DataSource.convertCivilFormat(vf);
            }
            catch (Exception exception) {
                return DataSource.this.outputVideoFormat;
            }
        }

        public Format[] getSupportedFormats() {
            if (DataSource.this.captureStream != null && DataSource.this.connected) {
                try {
                    List formatList = DataSource.this.captureStream.enumVideoFormats();
                    Format[] formats = new Format[formatList.size()];
                    for (int i = 0; i < formatList.size(); ++i) {
                        formats[i] = DataSource.convertCivilFormat((VideoFormat)formatList.get(i));
                    }
                    return formats;
                }
                catch (CaptureException e) {
                    logger.log(Level.WARNING, "" + (Object)((Object)e), e);
                }
            }
            return new Format[0];
        }

        public boolean isEnabled() {
            return DataSource.this.enabled;
        }

        public void setEnabled(boolean enabled) {
            DataSource.this.enabled = enabled;
        }

        public Format setFormat(Format format) {
            block4: {
                if (!(format instanceof javax.media.format.VideoFormat)) {
                    return null;
                }
                try {
                    if (!DataSource.this.connected || DataSource.this.started.getValue() || null == DataSource.this.captureStream) break block4;
                    List formatList = DataSource.this.captureStream.enumVideoFormats();
                    for (int i = 0; i < formatList.size(); ++i) {
                        javax.media.format.VideoFormat videoFormat = DataSource.convertCivilFormat((VideoFormat)formatList.get(i));
                        if (!format.matches(videoFormat)) continue;
                        DataSource.this.captureStream.setVideoFormat((VideoFormat)formatList.get(i));
                        DataSource.this.outputVideoFormat = videoFormat;
                        break;
                    }
                }
                catch (CaptureException ex) {
                    logger.log(Level.WARNING, "" + (Object)((Object)ex), ex);
                }
            }
            return DataSource.this.outputVideoFormat;
        }
    }

    private class MyPushBufferStream
    implements PushBufferStream {
        private MyPushBufferStream() {
        }

        public boolean endOfStream() {
            return false;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor(DataSource.CONTENT_TYPE);
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Format getFormat() {
            if (DataSource.this.outputVideoFormat == null) {
                logger.warning("outputVideoFormat == null, video format unknown.");
            }
            return DataSource.this.outputVideoFormat;
        }

        public void read(Buffer buffer) throws IOException {
            if (!DataSource.this.started.getValue()) {
                buffer.setOffset(0);
                buffer.setLength(0);
                buffer.setDiscard(true);
                return;
            }
            try {
                Buffer aBuffer = (Buffer)DataSource.this.jitterBuffer.get();
                buffer.setFlags(aBuffer.getFlags());
                buffer.setOffset(0);
                buffer.setData(aBuffer.getData());
                buffer.setLength(aBuffer.getLength());
                buffer.setFormat(aBuffer.getFormat());
                buffer.setSequenceNumber(aBuffer.getSequenceNumber());
                buffer.setTimeStamp(aBuffer.getTimeStamp());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            DataSource.this.transferHandlerHolder.setObject(transferHandler);
        }

        void notifyTransferHandler() {
            BufferTransferHandler handler = (BufferTransferHandler)DataSource.this.transferHandlerHolder.getObject();
            if (handler != null) {
                handler.transferData(this);
            }
        }
    }

    private class MyCaptureObserver
    implements CaptureObserver {
        private long sequenceNumber = 0L;

        private MyCaptureObserver() {
        }

        public void onError(CaptureStream sender, CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewImage(CaptureStream sender, Image image) {
            if (DataSource.this.started.getValue()) {
                BufferTransferHandler handler;
                long currentTime = System.nanoTime();
                javax.media.format.VideoFormat format = DataSource.convertCivilFormat(image.getFormat());
                if (null == DataSource.this.jitterBuffer) {
                    DataSource.this.jitterBuffer = new RingBuffer(DataSource.this.jitterbuflen);
                    logger.fine("jitterbuflen=" + DataSource.this.jitterbuflen);
                }
                Object object = DataSource.this.currentBufferMutex;
                synchronized (object) {
                    DataSource.this.currentBuffer = new Buffer();
                    DataSource.this.currentBuffer.setFlags(32896);
                    DataSource.this.currentBuffer.setOffset(0);
                    DataSource.this.currentBuffer.setData(image.getBytes());
                    DataSource.this.currentBuffer.setLength(image.getBytes().length);
                    DataSource.this.currentBuffer.setFormat(format);
                    DataSource.this.currentBuffer.setSequenceNumber(++this.sequenceNumber);
                    DataSource.this.currentBuffer.setTimeStamp(currentTime);
                }
                if (null != DataSource.this.pushBufferStream && (handler = (BufferTransferHandler)DataSource.this.transferHandlerHolder.getObject()) != null && !DataSource.this.jitterBuffer.put(DataSource.this.currentBuffer)) {
                    DataSource.this.pushBufferStream.notifyTransferHandler();
                }
                long currentTimestamp = currentTime;
                if (-1L == DataSource.this.lastTimestamp) {
                    DataSource.this.lastTimestamp = currentTimestamp;
                }
                DataSource.this.framesProcessed++;
                if (currentTimestamp - DataSource.this.lastTimestamp > 1000000000L) {
                    float diffTime = (float)(currentTimestamp - DataSource.this.lastTimestamp) / 1000000.0f;
                    DataSource.this.frameRate = (float)DataSource.this.framesProcessed * (1000.0f / diffTime);
                    DataSource.this.framesProcessed = 0;
                    DataSource.this.lastTimestamp = currentTimestamp;
                }
            }
        }
    }
}

