/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.javasound;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.SynchronizedBoolean;
import com.lti.utils.synchronization.SynchronizedObjectHolder;
import java.awt.Component;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.Owned;
import javax.media.Time;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.control.FrameProcessingControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import net.sf.fmj.media.AbstractGainControl;
import net.sf.fmj.media.protocol.javasound.AudioFormatComparator;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.RingBuffer;

public class DataSource
extends PushBufferDataSource
implements CaptureDevice {
    private static final boolean TRACE = true;
    private static final Logger logger = LoggerSingleton.logger;
    private MyPushBufferStream pushBufferStream;
    private TargetDataLine targetDataLine;
    private javax.sound.sampled.AudioFormat javaSoundAudioFormat;
    private AudioFormat jmfAudioFormat;
    private long buflenMS = 20L;
    private int buflen;
    private RingBuffer jitterBuffer = new RingBuffer(2);
    private PeakVolumeMeter levelControl;
    protected Object[] controls;
    private boolean connected;
    private static final String CONTENT_TYPE = "raw";
    private final SynchronizedBoolean started = new SynchronizedBoolean(false);
    private Format[] formatsArray;
    private boolean enabled = true;

    public DataSource() {
        this.levelControl = new PeakVolumeMeter();
        this.levelControl.setMute(true);
    }

    private void setJavaSoundAudioFormat(javax.sound.sampled.AudioFormat f) {
        this.javaSoundAudioFormat = f;
        this.jmfAudioFormat = JavaSoundUtils.convertFormat(this.javaSoundAudioFormat);
    }

    private void setJMFAudioFormat(AudioFormat f) {
        this.jmfAudioFormat = f;
        this.javaSoundAudioFormat = JavaSoundUtils.convertFormat(this.jmfAudioFormat);
    }

    public void connect() throws IOException {
        logger.fine("connect");
        if (this.connected) {
            return;
        }
        try {
            if (null == this.jmfAudioFormat) {
                Format[] formats = this.getSupportedFormats();
                AudioFormat audioFormat = (AudioFormat)formats[0];
                if (audioFormat.getSampleRate() == -1.0) {
                    AudioFormat newAudioFormat = new AudioFormat(audioFormat.getEncoding(), 44100.0, -1, -1);
                    this.setJMFAudioFormat((AudioFormat)newAudioFormat.intersects(audioFormat));
                } else {
                    this.setJMFAudioFormat(audioFormat);
                }
            }
            int mixerIndex = this.getMixerIndex();
            Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
            Mixer mixer = AudioSystem.getMixer(mixerInfo[mixerIndex]);
            this.targetDataLine = (TargetDataLine)mixer.getLine(new DataLine.Info(TargetDataLine.class, null));
            logger.fine("targetDataLine=" + this.targetDataLine);
            this.buflen = (int)((float)this.javaSoundAudioFormat.getFrameSize() * this.javaSoundAudioFormat.getSampleRate() * (float)this.buflenMS / 1000.0f);
            this.targetDataLine.open(this.javaSoundAudioFormat, this.buflen);
            logger.fine("buflen=" + this.buflen);
            this.pushBufferStream = new MyPushBufferStream();
            this.controls = new Object[]{new JavaSoundFormatControl(), new JavaSoundBufferControl(), new JitterBufferControl(), new FPC(), this.levelControl};
        }
        catch (LineUnavailableException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new IOException("" + e);
        }
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        logger.fine("disconnect");
        if (!this.connected) {
            return;
        }
        try {
            this.stop();
            if (this.targetDataLine != null) {
                this.targetDataLine.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
        finally {
            this.targetDataLine = null;
            this.pushBufferStream = null;
        }
        this.connected = false;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public void start() throws IOException {
        logger.fine("start");
        if (this.started.getValue()) {
            return;
        }
        this.targetDataLine.start();
        this.pushBufferStream.startAvailabilityThread();
        this.started.setValue(true);
    }

    public void stop() throws IOException {
        logger.fine("stop");
        if (!this.started.getValue()) {
            return;
        }
        try {
            if (this.targetDataLine != null) {
                this.targetDataLine.stop();
                this.targetDataLine.flush();
            }
            if (this.pushBufferStream != null) {
                this.pushBufferStream.stopAvailabilityThread();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.started.setValue(false);
        }
    }

    public Time getDuration() {
        return DURATION_UNBOUNDED;
    }

    public PushBufferStream[] getStreams() {
        logger.fine("getStreams");
        return new PushBufferStream[]{this.pushBufferStream};
    }

    private int getMixerIndex() {
        int mixerIndex = -1;
        try {
            String remainder = this.getLocator().getRemainder();
            if (remainder.startsWith("#")) {
                remainder = remainder.substring(1);
                mixerIndex = Integer.parseInt(remainder);
            }
        }
        catch (Exception dontcare) {
            // empty catch block
        }
        if (-1 == mixerIndex && this.getLocator().toString().startsWith("javasound://")) {
            for (int index = 0; index < 50; ++index) {
                Format[] formats = DataSource.querySupportedFormats(index);
                if (null == formats || formats.length <= 0) continue;
                mixerIndex = index;
                break;
            }
        }
        return mixerIndex;
    }

    private Format[] getSupportedFormats() {
        if (this.formatsArray != null) {
            return this.formatsArray;
        }
        int mixerIndex = this.getMixerIndex();
        this.formatsArray = DataSource.querySupportedFormats(mixerIndex);
        return this.formatsArray;
    }

    public static Format[] querySupportedFormats(int mixerIndex) {
        ArrayList<AudioFormat> formats = new ArrayList<AudioFormat>();
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        if (mixerIndex < 0 || mixerIndex >= mixerInfo.length) {
            return null;
        }
        Mixer mixer = AudioSystem.getMixer(mixerInfo[mixerIndex]);
        Line.Info[] infos = mixer.getTargetLineInfo();
        for (int i = 0; i < infos.length; ++i) {
            if (!(infos[i] instanceof DataLine.Info)) continue;
            javax.sound.sampled.AudioFormat[] af = ((DataLine.Info)infos[i]).getFormats();
            for (int j = 0; j < af.length; ++j) {
                AudioFormat jmfAudioFormat = JavaSoundUtils.convertFormat(af[j]);
                if (formats.contains(jmfAudioFormat)) continue;
                formats.add(jmfAudioFormat);
            }
        }
        Collections.sort(formats, Collections.reverseOrder(new AudioFormatComparator()));
        Format[] formatsArray = new Format[formats.size()];
        for (int i = 0; i < formats.size(); ++i) {
            formatsArray[i] = (Format)formats.get(i);
        }
        return formatsArray;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        int mixerIndex = this.getMixerIndex();
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        return new CaptureDeviceInfo(mixerInfo[mixerIndex].getName(), this.getLocator(), this.getSupportedFormats());
    }

    public FormatControl[] getFormatControls() {
        return new FormatControl[]{new JavaSoundFormatControl()};
    }

    private class PeakVolumeMeter
    extends AbstractGainControl {
        float peakLevel = 0.0f;

        private PeakVolumeMeter() {
        }

        public void processData(Buffer buf) {
            if (this.getMute() || buf.isDiscard() || buf.getLength() <= 0) {
                return;
            }
            AudioFormat af = (AudioFormat)buf.getFormat();
            byte[] data = (byte[])buf.getData();
            if (af.getEncoding().equalsIgnoreCase("LINEAR") && af.getSampleSizeInBits() == 16) {
                int msb = 0;
                int lsb = 1;
                if (af.getEndian() == 0) {
                    msb = 1;
                    lsb = 0;
                }
                if (af.getSigned() == 1) {
                    int peak = 0;
                    int samples = data.length / 2;
                    for (int i = 0; i < samples; ++i) {
                        int value = (data[i * 2 + msb] << 8) + (data[i * 2 + lsb] & 0xFF);
                        if (value < 0) {
                            value = -value;
                        }
                        if (value <= peak) continue;
                        peak = value;
                    }
                    this.peakLevel = (float)peak / 32768.0f;
                }
            }
        }

        public float setLevel(float level) {
            float result = this.getLevel();
            return result;
        }

        public float getLevel() {
            return this.peakLevel;
        }
    }

    private class FPC
    implements FrameProcessingControl,
    Owned {
        private FPC() {
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public int getFramesDropped() {
            return DataSource.this.jitterBuffer.getOverrunCounter();
        }

        public void setFramesBehind(float numFrames) {
        }

        public boolean setMinimalProcessing(boolean newMinimalProcessing) {
            return false;
        }

        public Component getControlComponent() {
            return null;
        }
    }

    private class JitterBufferControl
    implements BufferControl,
    Owned {
        private JitterBufferControl() {
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public long getBufferLength() {
            return DataSource.this.buflenMS * (long)DataSource.this.jitterBuffer.size();
        }

        public long setBufferLength(long time) {
            int jitterbuflen = (int)(time / DataSource.this.buflenMS);
            if (jitterbuflen < 1) {
                jitterbuflen = 1;
            }
            DataSource.this.jitterBuffer.resize(jitterbuflen);
            return (long)jitterbuflen * DataSource.this.buflenMS;
        }

        public long getMinimumThreshold() {
            return -1L;
        }

        public long setMinimumThreshold(long time) {
            return -1L;
        }

        public void setEnabledThreshold(boolean b) {
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public Component getControlComponent() {
            return null;
        }
    }

    private class JavaSoundBufferControl
    implements BufferControl,
    Owned {
        private JavaSoundBufferControl() {
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public long getBufferLength() {
            return DataSource.this.buflenMS;
        }

        public long setBufferLength(long time) {
            boolean isStarted = false;
            if (DataSource.this.started.getValue()) {
                isStarted = true;
                try {
                    DataSource.this.stop();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
            if (time < 20L) {
                time = 20L;
            } else if (time > 5000L) {
                time = 5000L;
            }
            DataSource.this.buflenMS = time;
            if (DataSource.this.connected) {
                DataSource.this.disconnect();
                try {
                    DataSource.this.connect();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
            if (isStarted) {
                try {
                    DataSource.this.start();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
            return DataSource.this.buflenMS;
        }

        public long getMinimumThreshold() {
            return -1L;
        }

        public long setMinimumThreshold(long time) {
            return -1L;
        }

        public void setEnabledThreshold(boolean b) {
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public Component getControlComponent() {
            return null;
        }
    }

    private class JavaSoundFormatControl
    implements FormatControl,
    Owned {
        private JavaSoundFormatControl() {
        }

        public Object getOwner() {
            return DataSource.this;
        }

        public Component getControlComponent() {
            return null;
        }

        public Format getFormat() {
            return DataSource.this.jmfAudioFormat;
        }

        public Format[] getSupportedFormats() {
            return DataSource.this.getSupportedFormats();
        }

        public boolean isEnabled() {
            return DataSource.this.enabled;
        }

        public void setEnabled(boolean enabled) {
            DataSource.this.enabled = enabled;
        }

        public Format setFormat(Format format) {
            DataSource.this.setJMFAudioFormat((AudioFormat)format);
            if (DataSource.this.connected) {
                DataSource.this.disconnect();
                try {
                    DataSource.this.connect();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "" + e, e);
                    return null;
                }
            }
            return DataSource.this.jmfAudioFormat;
        }
    }

    private class MyPushBufferStream
    implements PushBufferStream {
        private long sequenceNumber = 0L;
        private AvailabilityThread availabilityThread;
        private final SynchronizedObjectHolder transferHandlerHolder = new SynchronizedObjectHolder();

        private MyPushBufferStream() {
        }

        public boolean endOfStream() {
            return false;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor(DataSource.CONTENT_TYPE);
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Format getFormat() {
            return DataSource.this.jmfAudioFormat;
        }

        public void read(Buffer buffer) throws IOException {
            if (!DataSource.this.started.getValue()) {
                buffer.setOffset(0);
                buffer.setLength(0);
                buffer.setDiscard(true);
                return;
            }
            try {
                byte[] data = (byte[])DataSource.this.jitterBuffer.get();
                buffer.setFlags(33024);
                buffer.setOffset(0);
                buffer.setData(data);
                buffer.setLength(data.length);
                buffer.setFormat(DataSource.this.jmfAudioFormat);
                buffer.setSequenceNumber(++this.sequenceNumber);
                buffer.setTimeStamp(System.nanoTime());
                DataSource.this.levelControl.processData(buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void startAvailabilityThread() {
            this.availabilityThread = new AvailabilityThread();
            this.availabilityThread.setName("AvailabilityThread for " + this);
            this.availabilityThread.setDaemon(true);
            this.availabilityThread.start();
        }

        public void stopAvailabilityThread() throws InterruptedException {
            if (this.availabilityThread == null) {
                return;
            }
            this.availabilityThread.close();
            this.availabilityThread.waitUntilClosed();
            this.availabilityThread = null;
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.transferHandlerHolder.setObject(transferHandler);
        }

        private class AvailabilityThread
        extends CloseableThread {
            private AvailabilityThread() {
            }

            public void run() {
                logger.fine("jitterbuflen=" + DataSource.this.jitterBuffer.size());
                try {
                    byte[] data = new byte[DataSource.this.buflen];
                    while (!this.isClosing()) {
                        BufferTransferHandler handler;
                        int actuallyRead = DataSource.this.targetDataLine.read(data, 0, data.length);
                        if (actuallyRead <= 0 || (handler = (BufferTransferHandler)MyPushBufferStream.this.transferHandlerHolder.getObject()) == null || DataSource.this.jitterBuffer.put(data)) continue;
                        handler.transferData(MyPushBufferStream.this);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.setClosed();
            }
        }
    }
}

