/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.utility.LoggerSingleton;

public class RTCPHandler
implements SourceTransferHandler {
    private static final Logger logger = LoggerSingleton.logger;
    private RTPSessionMgr manager = null;

    public RTCPHandler(RTPSessionMgr manager) {
        this.manager = manager;
    }

    public void transferData(PushSourceStream stream) {
        try {
            byte[] buffer = new byte[stream.getMinimumTransferSize()];
            int length = stream.read(buffer, 0, buffer.length);
            this.manager.handleRTCPPacket(buffer, 0, length);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }
}

