/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

public class RTPHeader {
    public static final int VERSION = 2;
    public static final int MAX_PAYLOAD = 127;
    public static final int SIZE = 12;
    public static final int MAX_SEQUENCE = 65535;
    public static final long UINT_TO_LONG_CONVERT = 0xFFFFFFFFL;
    private static final int VERSION_MASK = 49152;
    private static final int VERSION_SHIFT = 14;
    private static final int PADDING_MASK = 8192;
    private static final int PADDING_SHIFT = 13;
    private static final int EXTENSION_MASK = 4096;
    private static final int EXTENSION_SHIFT = 12;
    private static final int CSRC_MASK = 3840;
    private static final int CSRC_SHIFT = 8;
    private static final int MARKER_MASK = 128;
    private static final int MARKER_SHIFT = 7;
    private static final int TYPE_MASK = 127;
    private static final int TYPE_SHIFT = 0;
    private int flags;
    private int sequence;
    private long timestamp;
    private long ssrc;

    public RTPHeader(DatagramPacket packet) throws IOException {
        this(packet.getData(), packet.getOffset(), packet.getLength());
    }

    public RTPHeader(byte[] data, int offset, int length) throws IOException {
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data, offset, length));
        this.flags = stream.readUnsignedShort();
        this.sequence = stream.readUnsignedShort();
        this.timestamp = (long)stream.readInt() & 0xFFFFFFFFL;
        this.ssrc = (long)stream.readInt() & 0xFFFFFFFFL;
        if (this.getVersion() != 2) {
            throw new IOException("Invalid Version");
        }
    }

    public int getFlags() {
        return this.flags;
    }

    short getVersion() {
        return (short)((this.getFlags() & 0xC000) >> 14);
    }

    short getPadding() {
        return (short)((this.getFlags() & 0x2000) >> 13);
    }

    short getExtension() {
        return (short)((this.getFlags() & 0x1000) >> 12);
    }

    short getCsrcCount() {
        return (short)((this.getFlags() & 0xF00) >> 8);
    }

    short getMarker() {
        return (short)((this.getFlags() & 0x80) >> 7);
    }

    short getPacketType() {
        return (short)((this.getFlags() & 0x7F) >> 0);
    }

    int getSequence() {
        return this.sequence;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    long getSsrc() {
        return this.ssrc;
    }

    int getSize() {
        return 12 + this.getCsrcCount() * 4;
    }

    public void print() {
        System.err.println(this.getVersion() + "|" + this.getPadding() + "|" + this.getExtension() + "|" + this.getCsrcCount() + "|" + this.getMarker() + "|" + this.getPacketType() + "|" + this.getSequence() + "|" + this.getTimestamp() + "|" + this.getSsrc());
    }
}

