/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;

@Deprecated
public class SocketInputStream
extends Thread
implements PushSourceStream {
    private static final int BUFFER_SIZE = 2048;
    private static final int NO_BUFFERS = 8;
    private DatagramSocket socket = null;
    private byte[][] buffer = new byte[8][2048];
    private int[] bufferSize = new int[8];
    private int buffersUsed = 0;
    private int currentReceive = 0;
    private int currentSend = 0;
    private boolean done = false;
    private Handler handler = null;

    public SocketInputStream(DatagramSocket socket) {
        this.socket = socket;
    }

    public synchronized int read(byte[] buffer, int offset, int length) {
        if (this.buffersUsed > 0) {
            int maxSize = length;
            if (this.bufferSize[this.currentSend] < length) {
                maxSize = this.bufferSize[this.currentSend];
            }
            System.arraycopy(this.buffer[this.currentSend], 0, buffer, offset, maxSize);
            this.currentSend = (this.currentSend + 1) % this.buffer.length;
            --this.buffersUsed;
            return maxSize;
        }
        return 0;
    }

    public int getMinimumTransferSize() {
        if (this.buffersUsed > 0) {
            return this.bufferSize[this.currentSend];
        }
        return 0;
    }

    public void setTransferHandler(SourceTransferHandler transferHandler) {
        this.handler = new Handler(transferHandler, this);
        this.handler.start();
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean endOfStream() {
        return this.done && this.buffersUsed == 0;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    private int getQueueLength() {
        return this.buffersUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            SocketInputStream socketInputStream = this;
            synchronized (socketInputStream) {
                try {
                    if (this.buffersUsed < this.buffer.length) {
                        DatagramPacket packet = new DatagramPacket(this.buffer[this.currentReceive], 0, this.buffer[this.currentReceive].length);
                        this.socket.receive(packet);
                        this.bufferSize[this.currentReceive] = packet.getLength();
                        this.currentReceive = (this.currentReceive + 1) % this.buffer.length;
                        ++this.buffersUsed;
                        if (this.handler != null) {
                            this.handler.dataReady();
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void kill() {
        this.done = true;
        this.socket.close();
    }

    private class Handler
    extends Thread {
        private SourceTransferHandler handle = null;
        private SocketInputStream stream = null;
        private boolean dataReady = false;

        public Handler(SourceTransferHandler handler, SocketInputStream stream) {
            this.handle = handler;
            this.stream = stream;
        }

        public synchronized void dataReady() {
            this.dataReady = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stream.endOfStream()) {
                while (!this.dataReady && this.stream.getQueueLength() == 0) {
                    Handler handler = this;
                    synchronized (handler) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.dataReady = false;
                if (this.stream.endOfStream()) continue;
                this.handle.transferData(this.stream);
            }
        }
    }
}

