/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.qt;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.text.DecimalFormat;
import java.util.logging.Logger;
import net.sf.fmj.qt.QTSnapperException;
import net.sf.fmj.utility.LoggerSingleton;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.qd.QDGraphics;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.DSequence;
import quicktime.std.image.ImageDescription;
import quicktime.std.movies.Movie;
import quicktime.std.movies.TimeInfo;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.Media;
import quicktime.std.movies.media.MediaSample;
import quicktime.util.QTHandleRef;
import quicktime.util.RawEncodedImage;

public class QTSnapper {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean isSessionOpen = false;
    private final Movie movie;
    private final Track videoTrack;
    private final Media vidMedia;
    private MediaSample mediaSample;
    private final int rowInts;
    private final int[] pixData;
    private final int numSamples;
    private final int duration;
    private final int timeScale;
    private int sampIdx;
    private final QDGraphics qdGraphics;
    private final DSequence dSeq;
    private final int width;
    private final int height;
    private final BufferedImage img;
    private final long startTime;
    private long numFramesMade;
    private static final DecimalFormat frameDf = new DecimalFormat("0.#");
    private TimeInfo ti;

    public QTSnapper(String theURL) throws QTException, QTSnapperException {
        logger.info("Loading movie: " + theURL + "...");
        QTSession.open();
        this.isSessionOpen = true;
        DataRef urlMovie = new DataRef(theURL);
        this.movie = Movie.fromDataRef((DataRef)urlMovie, (int)1);
        this.videoTrack = this.movie.getIndTrackType(1, 1986618469, 1);
        if (this.videoTrack == null) {
            throw new QTSnapperException("Sorry, not a video");
        }
        this.vidMedia = this.videoTrack.getMedia();
        this.numSamples = this.vidMedia.getSampleCount();
        this.duration = this.vidMedia.getDuration();
        this.timeScale = this.vidMedia.getTimeScale();
        this.sampIdx = 1;
        this.mediaSample = this.vidMedia.getSample(0, this.vidMedia.sampleNumToMediaTime((int)this.sampIdx).time, 1);
        ImageDescription imgDesc = (ImageDescription)this.mediaSample.description;
        this.width = imgDesc.getWidth();
        this.height = imgDesc.getHeight();
        this.qdGraphics = new QDGraphics(imgDesc.getBounds());
        this.dSeq = new DSequence(imgDesc, this.qdGraphics, imgDesc.getBounds(), null, null, 1, 1024, CodecComponent.bestFidelityCodec);
        this.rowInts = this.qdGraphics.getPixMap().getRowBytes() >>> 2;
        this.pixData = new int[this.rowInts * this.height];
        this.img = new BufferedImage(this.width, this.height, 1);
        this.startTime = System.currentTimeMillis();
        this.numFramesMade = 0L;
    }

    public synchronized void stopMovie() {
        if (this.isSessionOpen) {
            long duration = System.currentTimeMillis() - this.startTime;
            double frameRate = (double)this.numFramesMade * 1000.0 / (double)duration;
            logger.info("FPS: " + frameDf.format(frameRate));
            QTSession.close();
            this.isSessionOpen = false;
        }
    }

    public synchronized void next() throws QTException {
        if (!this.isSessionOpen) {
            return;
        }
        if (this.sampIdx > this.numSamples) {
            return;
        }
        this.ti = this.vidMedia.sampleNumToMediaTime(this.sampIdx);
        this.mediaSample = this.vidMedia.getSample(0, this.ti.time, 1);
        ++this.sampIdx;
        this.writeToBufferedImage(this.mediaSample, this.img);
        ++this.numFramesMade;
    }

    public synchronized BufferedImage getFrame() {
        if (!this.isSessionOpen) {
            return null;
        }
        if (this.sampIdx > this.numSamples) {
            return null;
        }
        return this.img;
    }

    public synchronized int getFrameTime() {
        if (this.sampIdx > this.numSamples) {
            return -1;
        }
        return this.ti.time;
    }

    private void writeToBufferedImage(MediaSample mediaSample, BufferedImage img) throws QTException {
        RawEncodedImage rawIm = RawEncodedImage.fromQTHandle((QTHandleRef)mediaSample.data);
        this.dSeq.decompressFrameS(rawIm, 0);
        rawIm.disposeQTObject();
        WritableRaster tile = img.getWritableTile(0, 0);
        int[] imgPixelData = ((DataBufferInt)tile.getDataBuffer()).getData();
        RawEncodedImage rawIm2 = this.qdGraphics.getPixMap().getPixelData();
        if (this.rowInts != this.width) {
            rawIm2.copyToArray(0, this.pixData, 0, this.pixData.length);
            int pixIndex = 0;
            int destPixIndex = 0;
            for (int row = 0; row < this.height; ++row) {
                int cLimit = pixIndex + this.width;
                for (int cIndex = pixIndex; cIndex < cLimit; ++cIndex) {
                    imgPixelData[destPixIndex++] = this.pixData[cIndex];
                }
                pixIndex += this.rowInts;
            }
        } else {
            rawIm2.copyToArray(0, imgPixelData, 0, this.width * this.height);
        }
        img.releaseWritableTile(0, 0);
    }

    public int getImageWidth() {
        return this.width;
    }

    public int getImageHeight() {
        return this.height;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTimeScale() {
        return this.timeScale;
    }
}

