/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.util.logging.Logger;
import net.sf.fmj.ui.wizard.WizardPanelDescriptor;
import net.sf.fmj.ui.wizards.ChooseSourcePanel;
import net.sf.fmj.ui.wizards.ContentAndTrackFormatPanelDescriptor;
import net.sf.fmj.ui.wizards.ProcessorWizardConfig;
import net.sf.fmj.ui.wizards.ProcessorWizardResult;
import net.sf.fmj.ui.wizards.WizardStepException;
import net.sf.fmj.utility.LoggerSingleton;

public class ChooseSourcePanelDescriptor
extends WizardPanelDescriptor {
    private static final Logger logger = LoggerSingleton.logger;
    public static final String IDENTIFIER = ChooseSourcePanelDescriptor.class.getName();
    private final ProcessorWizardConfig config;
    private final ProcessorWizardResult result;

    public ChooseSourcePanelDescriptor(ProcessorWizardConfig config, ProcessorWizardResult result) {
        super(IDENTIFIER, new ChooseSourcePanel());
        this.config = config;
        this.result = result;
    }

    public Object getNextPanelDescriptor() {
        return ContentAndTrackFormatPanelDescriptor.IDENTIFIER;
    }

    public Object getBackPanelDescriptor() {
        return null;
    }

    public ChooseSourcePanel getChooseSourcePanel() {
        return (ChooseSourcePanel)this.getPanelComponent();
    }

    public boolean aboutToDisplayPanel(Object prevId) {
        if (prevId == this.getBackPanelDescriptor()) {
            if (this.config.url != null) {
                this.getChooseSourcePanel().getTextFieldURL().setText(this.config.url);
            }
            return true;
        }
        return super.aboutToDisplayPanel(prevId);
    }

    public boolean aboutToHidePanel(Object idOfNext) {
        if (idOfNext == this.getNextPanelDescriptor()) {
            this.config.url = this.getChooseSourcePanel().getTextFieldURL().getText();
            if (this.config.url == null || this.config.url.equals("")) {
                this.showError("Source URL may not be blank");
                return false;
            }
            try {
                this.result.step1_createProcessorAndSetUrl(this.config);
            }
            catch (WizardStepException e1) {
                this.showError(e1);
                return false;
            }
            return true;
        }
        return super.aboutToHidePanel(idOfNext);
    }
}

