/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.awt.Component;
import java.util.logging.Logger;
import javax.media.control.TrackControl;
import net.sf.fmj.media.datasink.rtp.ParsedRTPUrl;
import net.sf.fmj.media.datasink.rtp.ParsedRTPUrlElement;
import net.sf.fmj.media.datasink.rtp.RTPUrlParser;
import net.sf.fmj.media.datasink.rtp.RTPUrlParserException;
import net.sf.fmj.ui.objeditor.ComponentValidationException;
import net.sf.fmj.ui.objeditor.ComponentValidator;
import net.sf.fmj.ui.utils.ErrorDialog;
import net.sf.fmj.ui.wizard.WizardPanelDescriptor;
import net.sf.fmj.ui.wizards.ContentAndTrackFormatPanelDescriptor;
import net.sf.fmj.ui.wizards.RTPDestPanel;
import net.sf.fmj.ui.wizards.RTPTransmitWizardConfig;
import net.sf.fmj.ui.wizards.RTPTransmitWizardResult;
import net.sf.fmj.ui.wizards.WizardStepException;
import net.sf.fmj.utility.LoggerSingleton;

public class RTPDestPanelDescriptor
extends WizardPanelDescriptor {
    private static final Logger logger = LoggerSingleton.logger;
    public static final String IDENTIFIER = RTPDestPanelDescriptor.class.getName();
    private final RTPDestPanel panel = new RTPDestPanel();
    private final RTPTransmitWizardConfig config;
    private final RTPTransmitWizardResult result;

    public RTPDestPanelDescriptor(RTPTransmitWizardConfig config, RTPTransmitWizardResult result) {
        this.setPanelDescriptorIdentifier(IDENTIFIER);
        this.setPanelComponent(this.panel);
        this.config = config;
        this.result = result;
    }

    public Object getNextPanelDescriptor() {
        return FINISH;
    }

    public Object getBackPanelDescriptor() {
        return ContentAndTrackFormatPanelDescriptor.IDENTIFIER;
    }

    public RTPDestPanel getRTPDestPanel() {
        return (RTPDestPanel)this.getPanelComponent();
    }

    public boolean aboutToDisplayPanel(Object prevId) {
        if (prevId == this.getBackPanelDescriptor()) {
            int i;
            int numEnabled = 0;
            TrackControl[] trackControls = this.result.processor.getTrackControls();
            if (trackControls.length == 0) {
                this.showError("No tracks available");
                return false;
            }
            for (i = 0; i < trackControls.length; ++i) {
                if (!trackControls[i].isEnabled()) continue;
                ++numEnabled;
            }
            if (numEnabled < 1) {
                this.showError("At least 1 track must be enabled");
                return false;
            }
            for (i = 0; i < trackControls.length; ++i) {
                if (!trackControls[i].isEnabled()) continue;
                boolean audio = true;
                this.getRTPDestPanel().addTrack(i, audio);
                if (this.config.destUrl == null) continue;
                try {
                    ParsedRTPUrl parsedRTPUrl = RTPUrlParser.parse(this.config.destUrl);
                    this.getRTPDestPanel().getTextSessionAddress(i).setText(parsedRTPUrl.elements[i].host);
                    this.getRTPDestPanel().getTextPort(i).setText("" + parsedRTPUrl.elements[i].port);
                    this.getRTPDestPanel().getComboTTL(i).setSelectedItem("" + parsedRTPUrl.elements[i].ttl);
                    continue;
                }
                catch (RTPUrlParserException ex) {
                    logger.warning("Unable to parse RTP URL: " + this.config.destUrl + ": " + ex);
                }
            }
        }
        return true;
    }

    public boolean aboutToHidePanel(Object idOfNext) {
        if (idOfNext == this.getNextPanelDescriptor()) {
            ParsedRTPUrl destUrl = null;
            TrackControl[] trackControls = this.result.processor.getTrackControls();
            for (int i = 0; i < trackControls.length; ++i) {
                if (!trackControls[i].isEnabled()) continue;
                boolean audio = true;
                ComponentValidator v = new ComponentValidator();
                try {
                    v.validateNotEmpty(this.getRTPDestPanel().getTextSessionAddress(i), this.getRTPDestPanel().getLabelSessionAddress());
                    v.validateNotEmpty(this.getRTPDestPanel().getTextPort(i), this.getRTPDestPanel().getLabelPort());
                    v.validateInteger(this.getRTPDestPanel().getTextPort(i), this.getRTPDestPanel().getLabelPort());
                    v.validateNotEmpty(this.getRTPDestPanel().getComboTTL(i), this.getRTPDestPanel().getLabelTTL());
                    v.validateInteger(this.getRTPDestPanel().getComboTTL(i), this.getRTPDestPanel().getLabelTTL());
                }
                catch (ComponentValidationException e) {
                    ErrorDialog.showError((Component)this.getRTPDestPanel(), e.getMessage());
                    return false;
                }
                String sessionAddress = this.getRTPDestPanel().getTextSessionAddress(i).getText();
                int port = Integer.parseInt(this.getRTPDestPanel().getTextPort(i).getText());
                int ttl = Integer.parseInt((String)this.getRTPDestPanel().getComboTTL(i).getSelectedItem());
                ParsedRTPUrlElement e = new ParsedRTPUrlElement();
                e.host = sessionAddress;
                e.port = port;
                e.ttl = ttl;
                e.type = audio ? "audio" : "video";
                logger.fine("ParsedRTPUrlElement: " + e);
                destUrl = new ParsedRTPUrl(e);
            }
            try {
                this.config.destUrl = destUrl.toString();
                this.result.step4_setDestUrlAndStart(this.config);
            }
            catch (WizardStepException e) {
                this.showError(e);
                return false;
            }
        }
        return true;
    }
}

