/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger {
    private java.util.logging.Logger utilLogger;
    private Object commonsLogger;
    private Map<String, Method> METHOD_CACHE_NO_PARAMS;
    private Map<String, Method> METHOD_CACHE_ONE_PARAM;
    private Map<String, Method> METHOD_CACHE_TWO_PARAMS;
    private static Class<?> logFactoryClass;
    private static Class<?> logClass;
    private static Method getLogMethod;
    private static final Object[] EMPTY_ARGS;
    private static final Class[] CLASS_ARGS_EMPTY;
    private static final Class[] CLASS_ARGS_ONE;
    private static final Class[] CLASS_ARGS_TWO;
    public static LoggerType LOGGER_TYPE;

    public static Logger getLogger(String string) {
        if (LOGGER_TYPE == null) {
            LOGGER_TYPE = Logger.getLoggerType();
        }
        if (LOGGER_TYPE == LoggerType.COMMONS) {
            try {
                Object object = getLogMethod.invoke(null, string);
                return new Logger(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return new Logger(java.util.logging.Logger.getLogger(string));
    }

    private static LoggerType getLoggerType() {
        Object var0 = null;
        try {
            logFactoryClass = Class.forName("org.apache.commons.logging.LogFactory");
            getLogMethod = logFactoryClass.getMethod("getLog", String.class);
            logClass = Class.forName("org.apache.commons.logging.Log");
            return LoggerType.COMMONS;
        }
        catch (Throwable throwable) {
            return LoggerType.JAVA;
        }
    }

    public Logger(java.util.logging.Logger logger) {
        this.utilLogger = logger;
    }

    public Logger(Object object) {
        this.commonsLogger = object;
    }

    public boolean isLoggable(Level level) {
        if (this.utilLogger != null) {
            java.util.logging.Level level2 = this.getJavaLevelFor(level);
            return level2 != null && this.utilLogger.isLoggable(level2);
        }
        if (this.commonsLogger != null) {
            switch (level) {
                case ERROR: {
                    return (Boolean)this.callCommonsLogger("isErrorEnabled");
                }
                case FATAL: {
                    return (Boolean)this.callCommonsLogger("isFatalEnabled");
                }
                case WARN: {
                    return (Boolean)this.callCommonsLogger("isWarnEnabled");
                }
                case INFO: {
                    return (Boolean)this.callCommonsLogger("isInfoEnabled");
                }
                case DEBUG: {
                    return (Boolean)this.callCommonsLogger("isDebugEnabled");
                }
                case TRACE: {
                    return (Boolean)this.callCommonsLogger("isTraceEnabled");
                }
            }
        }
        return false;
    }

    private java.util.logging.Level getJavaLevelFor(Level level) {
        switch (level) {
            case FATAL: {
                return java.util.logging.Level.SEVERE;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case TRACE: {
                return java.util.logging.Level.FINEST;
            }
        }
        return null;
    }

    public void debug(String string) {
        this.log(Level.DEBUG, string);
    }

    public void log(Level level, String string) {
        this.log(level, string, null);
    }

    public void log(Level level, String string, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (this.utilLogger != null) {
            java.util.logging.Level level2 = this.getJavaLevelFor(level);
            if (throwable == null) {
                this.utilLogger.log(level2, string);
            } else {
                this.utilLogger.log(level2, string, throwable);
            }
        } else if (this.commonsLogger != null) {
            if (throwable == null) {
                switch (level) {
                    case ERROR: {
                        this.callCommonsLogger("error", string);
                        break;
                    }
                    case FATAL: {
                        this.callCommonsLogger("fatal", string);
                        break;
                    }
                    case WARN: {
                        this.callCommonsLogger("warn", string);
                        break;
                    }
                    case INFO: {
                        this.callCommonsLogger("info", string);
                        break;
                    }
                    case DEBUG: {
                        this.callCommonsLogger("debug", string);
                        break;
                    }
                    case TRACE: {
                        this.callCommonsLogger("trace", string);
                    }
                }
            } else {
                switch (level) {
                    case ERROR: {
                        this.callCommonsLogger("error", string, throwable);
                        break;
                    }
                    case FATAL: {
                        this.callCommonsLogger("fatal", string, throwable);
                        break;
                    }
                    case WARN: {
                        this.callCommonsLogger("warn", string, throwable);
                        break;
                    }
                    case INFO: {
                        this.callCommonsLogger("info", string, throwable);
                        break;
                    }
                    case DEBUG: {
                        this.callCommonsLogger("debug", string, throwable);
                        break;
                    }
                    case TRACE: {
                        this.callCommonsLogger("trace", string, throwable);
                    }
                }
            }
        }
    }

    private Object callCommonsLogger(String string) {
        if (this.METHOD_CACHE_NO_PARAMS == null) {
            this.METHOD_CACHE_NO_PARAMS = new HashMap<String, Method>();
        }
        return this.callCommonsLogger(this.METHOD_CACHE_NO_PARAMS, string, CLASS_ARGS_EMPTY, EMPTY_ARGS);
    }

    private Object callCommonsLogger(String string, String string2) {
        if (this.METHOD_CACHE_ONE_PARAM == null) {
            this.METHOD_CACHE_ONE_PARAM = new HashMap<String, Method>();
        }
        return this.callCommonsLogger(this.METHOD_CACHE_ONE_PARAM, string, CLASS_ARGS_ONE, new Object[]{string2});
    }

    private Object callCommonsLogger(String string, String string2, Throwable throwable) {
        if (this.METHOD_CACHE_TWO_PARAMS == null) {
            this.METHOD_CACHE_TWO_PARAMS = new HashMap<String, Method>();
        }
        return this.callCommonsLogger(this.METHOD_CACHE_TWO_PARAMS, string, CLASS_ARGS_TWO, new Object[]{string2, throwable});
    }

    private Object callCommonsLogger(Map<String, Method> map, String string, Class[] classArray, Object[] objectArray) {
        Method method = map.get(string);
        if (method == null) {
            try {
                method = logClass.getMethod(string, classArray);
                map.put(string, method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(this.commonsLogger, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    static {
        EMPTY_ARGS = new Object[0];
        CLASS_ARGS_EMPTY = new Class[0];
        CLASS_ARGS_ONE = new Class[]{Object.class};
        CLASS_ARGS_TWO = new Class[]{Object.class, Throwable.class};
        LOGGER_TYPE = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoggerType {
        JAVA,
        COMMONS;

    }
}

